<?php


class Model extends CI_Model
{
	public function add($table, $data)
	{
		return $this->db->insert($table, $data);
	}
	public function edit($tb,$data,$cond) 
	{
		return $this->db->where($cond)->update($tb,$data);
	}
	public function deleteData($tb,$cond)
	{
	 	return $this->db->where($cond)->delete($tb);
	}
	public function getRowData($table,$cond,$limit=null,$order_column=null,$order_type=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		return $this->db->get_where($table, $cond)->row_array();
		  
	}
	public function getResultData($tb,$cond,$limit=null,$order_column=null,$order_type=null,$where_in_column=null,$where_in_arr=null,$where_not_in_arr=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		if ($where_in_arr!==null) {
			$this->db->where_in($where_in_column, $where_in_arr);
		}
		if ($where_not_in_arr!==null && !empty($where_not_in_arr)) {
			$this->db->where_not_in($where_in_column, $where_not_in_arr);
		}
		return $this->db->get_where($tb, $cond)->result_array();
	}
	public function countData($table,$cond)
	{
		return $this->db->get_where($table, $cond)->num_rows();
	}
	public function getSum($table, $column, $where = []) {
		$this->db->select_sum($column);
		if (!empty($where)) {
			$this->db->where($where);
		}
		$query = $this->db->get($table);
		$result = $query->row_array();
		return isset($result[$column]) ? floatval($result[$column]) : 0;
	}

	public function fetch_state($cid,$sid)
    {
        $data = $this->db->get_where('states', array('country_id' => $cid))->result_array();
        echo "<option value=''>Select State</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_city($sid,$cid)
    {
        $data = $this->db->get_where('cities', array('state_id' => $sid))->result_array();
        echo "<option value=''>Select City</option>";
        foreach ($data as $val) {
			if($val['id'] == $cid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_chapter($subject_id,$chapter_id)
    {
        $data = $this->db->get_where('chapter', array('subject_id' => $subject_id))->result_array();
        echo "<option value=''>Select Chapter</option>";
        foreach ($data as $val) {
			if($val['id'] == $chapter_id)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_subjects($cid,$sid)
    {
        $data = $this->db->get_where('subject', array('class_standard_id' => $cid))->result_array();
        echo "<option value=''>Select Subject</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_class($board_id,$class_standard_id)
    {
        $data = $this->db->get_where('class_standard', array('board_id' => $board_id))->result_array();
        echo "<option value=''>Select Class</option>";
        foreach ($data as $val) {
			if($val['id'] == $class_standard_id)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }

	// public function send_otp($mobile,$otp) {
	// 	//Your authentication key
	//   $authKey = "43960A85hPH9eE54f691c4";
	//   $dlt = "1007160969008190519";
	  
	//   //Multiple mobiles numbers separated by comma
	//   $mobileNumber = '91'."$mobile";
	  
	//   //Sender ID,While using route4 sender id should be 6 characters long.
	//   $senderId = "TCHICM";
	  
	//   //Your message to send, Add URL encoding here.
	//   $message = urlencode("Hi! Please enter $otp as your OTP to proceed further. Techicom");
	//   // echo $message;
	//   // die('B');
	//   //Define route 
	//   $route    = "4";
	//   //Prepare you post parameters
	//   $postData = array(
	// 	  'authkey' => $authKey,
	// 	  'mobiles' => $mobileNumber,
	// 	  'message' => $message,
	// 	  'sender' => $senderId,
	// 	  'route' => $route,
	// 	  'DLT_TE_ID' => $dlt
	//   );
	  
	//   //API URL
	//   $url = "https://control.msg91.com/api/sendhttp.php";
	  
	//   // init the resource
	//   $ch = curl_init();
	//   curl_setopt_array($ch, array(
	// 	  CURLOPT_URL => $url,
	// 	  CURLOPT_RETURNTRANSFER => true,
	// 	  CURLOPT_POST => true,
	// 	  CURLOPT_POSTFIELDS => $postData
	// 	  //,CURLOPT_FOLLOWLOCATION => true
	//   ));
	  
	  
	//   //Ignore SSL certificate verification
	//   curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	//   curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	  
	  
	//   //get response
	//   $output = curl_exec($ch);
	//   //Print error if any
	//   if (curl_errno($ch)) {
	// 	  $error = 'error:' . curl_error($ch);
	//   }
	  
	//    curl_close($ch);
	// 	  $response['isSuccess'] = true;
	//   $response['message'] = 'Application place succeessfully';
	//   return true;
	// 	  // json_encode($output);
	  
	// }
	public function send_otp($mobile, $otp) {
		$authKey = "43960A85hPH9eE54f691c4";
		$templateId = "1007160969008190519";
		$sender = "TCHICM"; // Sender ID
		$message = urlencode("Hi! Please enter $otp as your OTP to proceed further. Techicom");
		$mobileNumber = "91" . $mobile;
	
		// Construct URL
		$url = "https://control.msg91.com/api/v2/sendsms?route=4&unicode=1&sender=$sender&DLT_TE_ID=$templateId&encrypt=0&message=$message&mobiles=$mobileNumber&authkey=$authKey";
	
		// Initialize cURL
		$curl = curl_init();
		curl_setopt_array($curl, [
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_SSL_VERIFYHOST => 0,
			CURLOPT_SSL_VERIFYPEER => 0
		]);
	
		// Execute request
		$response = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);
	
		if ($err) {
			return 'false';
		}
	
		$result = json_decode($response, true);
		if (isset($result['type']) && $result['type'] === "success") {
			return 'true'; 
		} else {
			return 'false'; 
		}
	}
	
	
}

?>