<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room_pricing extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
        $this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title']      = 'Room Pricing';
        $data['properties'] = $this->model->getResultData('properties', []); 
        $data['rooms']      = $this->model->getResultData('rooms', []);
        $data['price_dates']      = $this->model->getResultData('price_dates', ['is_disable'=>0]);
        $page = 'room_pricing/index';
        $this->header_and_footer($page, $data);
    }

    // public function addPricing()
    // {
    //     $room_id       = $this->input->post('room_id');
    //     $property_id   = $this->input->post('property_id');
    //     $price_dates   = $this->input->post('price_date_id');
    //     $prices        = $this->input->post('price');

    //     if (empty($room_id) || empty($price_dates) || empty($prices)) {
    //         echo json_encode(['return' => false, 'msg' => 'Missing required fields']);
    //         return;
    //     }

    //     $inserted = 0;
    //     $skipped  = 0;

    //     foreach ($price_dates as $i => $price_date_id) {
    //         $price = isset($prices[$i]) ? $prices[$i] : 0;

    //         // check if already exists for same room + date range
    //         $exists = $this->model->countData('room_pricing', [
    //             'room_id'       => $room_id,
    //             'price_date_id' => $price_date_id
    //         ]);

    //         if ($exists > 0) {
    //             $skipped++;
    //             continue;
    //         }

    //         $data = [
    //             'room_id'       => $room_id,
    //             'price_date_id' => $price_date_id,
    //             'price'         => $price,
    //             'is_disable'    => 0,
    //         ];

    //         if ($this->model->add('room_pricing', $data)) {
    //             $inserted++;
    //         }
    //     }

    //     // log only once
    //     if ($inserted > 0) {
    //         $this->createLog(
    //             $this->session->userdata('id'),
    //             $this->session->userdata('role'),
    //             $room_id,
    //             'add',
    //             'Room Pricing (Multiple Date Wise)'
    //         );
    //     }

    //     if ($inserted > 0 && $skipped == 0) {
    //         $msg = 'All prices added successfully.';
    //     } elseif ($inserted > 0 && $skipped > 0) {
    //         $msg = "Some prices added successfully. ($skipped duplicate skipped)";
    //     } else {
    //         $msg = 'No new pricing added (already exists for selected date ranges).';
    //     }

    //     echo json_encode(['return' => ($inserted > 0), 'msg' => $msg]);
    // }
public function addPricing()
{
    $room_id = $this->input->post('room_id');
    $dates   = $this->input->post('price_date_id');

    if(empty($room_id) || empty($dates)){
        echo json_encode(['return'=>false,'msg'=>'Missing required fields']);
        return;
    }

    $inserted = 0;
    $plans = ['ep','cp','map','ap'];

    foreach($dates as $i => $date_id){

        foreach($plans as $plan){

            // duplicate check per meal plan
            $exists = $this->model->countData('room_pricing', [
                'room_id'       => $room_id,
                'price_date_id' => $date_id,
                'meal_plan'     => strtoupper($plan)
            ]);

            if($exists > 0) continue;

            $data = [
                'room_id'       => $room_id,
                'price_date_id' => $date_id,
                'meal_plan'     => strtoupper($plan),

                'room_rate' => $_POST[$plan.'_room'][$i] ?? 0,
                'eb_adult'  => $_POST[$plan.'_eba'][$i] ?? 0,
                'eb_child'  => $_POST[$plan.'_ebc'][$i] ?? 0,
                'cnb'       => $_POST[$plan.'_cnb'][$i] ?? 0,
            ];

            if($this->model->add('room_pricing', $data)){
                $inserted++;
            }
        }
    }

    if($inserted > 0){
        $this->createLog(
            $this->session->userdata('id'),
            $this->session->userdata('role'),
            $room_id,
            'add',
            'Room Pricing Matrix'
        );

        echo json_encode(['return'=>true,'msg'=>'Pricing saved successfully']);
    } else {
        echo json_encode(['return'=>false,'msg'=>'All selected date ranges already exist']);
    }
}




    public function viewPricing()
    {
        $data['list'] = $this->room_model->getRoomPricingResultData(); 
        $this->load->view('room_pricing/tb', $data);
    }

public function editPricing()
{
    $room_id = $this->input->post('id');

    $this->db
        ->select('
            rp.*,
            pd.name as date_name,
            pd.from_date,
            pd.to_date,
            r.property_id,
            r.name as room_name
        ')
        ->from('room_pricing rp')
        ->join('price_dates pd', 'pd.id = rp.price_date_id', 'left')
        ->join('rooms r', 'r.id = rp.room_id', 'left')
        ->where('rp.room_id', $room_id)
        ->order_by('pd.from_date', 'ASC');

    $rows = $this->db->get()->result_array();

    $grouped = [];

    foreach ($rows as $row) {

        $date_id = $row['price_date_id'];

        if (!isset($grouped[$date_id])) {
            $grouped[$date_id] = [
                'date_id'    => $date_id,
                'date_name'  => $row['date_name'],
                'from_date'  => $row['from_date'],
                'to_date'    => $row['to_date'],
                'plans'      => []
            ];
        }

        $grouped[$date_id]['plans'][$row['meal_plan']] = [
            'pricing_id' => $row['id'],
            'room_rate'  => $row['room_rate'],
            'eb_adult'   => $row['eb_adult'],
            'eb_child'   => $row['eb_child'],
            'cnb'        => $row['cnb']
        ];
    }

    $response = [
        'room_id'     => $room_id,
        'property_id' => $rows[0]['property_id'] ?? null,
        'room_name'   => $rows[0]['room_name'] ?? null,
        'dates'       => array_values($grouped)
    ];

    echo json_encode($response);
}





public function updatePricing()
{
    $room_id  = $_POST['room_id'];
    $date_ids = $_POST['price_date_id'] ?? [];

    if(empty($room_id) || empty($date_ids)){
        echo json_encode(['return'=>false,'msg'=>'Invalid request']);
        return;
    }

    $plans = ['ep','cp','map','ap'];

    // delete existing rows first (clean replace strategy)
    $this->db->where('room_id', $room_id)->delete('room_pricing');

    foreach($date_ids as $i => $date_id){

        foreach($plans as $plan){

            $data = [
                'room_id'       => $room_id,
                'price_date_id' => $date_id,
                'meal_plan'     => strtoupper($plan),
                'room_rate'     => $_POST[$plan.'_room'][$i] ?? 0,
                'eb_adult'      => $_POST[$plan.'_eba'][$i] ?? 0,
                'eb_child'      => $_POST[$plan.'_ebc'][$i] ?? 0,
                'cnb'           => $_POST[$plan.'_cnb'][$i] ?? 0
            ];

            $this->model->add('room_pricing', $data);
        }
    }

    $this->createLog(
        $this->session->userdata('id'),
        $this->session->userdata('role'),
        $room_id,
        'edit',
        'Room Pricing Matrix'
    );

    echo json_encode(['return'=>true,'msg'=>'Pricing updated successfully']);
}





    public function getRoomsByProperty()
    {
        $property_id = $this->input->post('property_id');
        $rooms = $this->model->getResultData('rooms', ['property_id' => $property_id]);

        $options = '<option value="">Select Room</option>';
        foreach($rooms as $room){
            $options .= '<option value="'.$room['id'].'">'.$room['name'].'</option>';
        }
        echo $options;
    }

}
