<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Agency extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
	{
		$data['title'] = 'Agency';
		
		$page = 'agency/index';
		$this->header_and_footer($page, $data);
	}
	
  
	public function addAgency()
	{
		$countData = $this->model->countData('agency', [
			'email'  => $_POST['email'],
			'mobile' => $_POST['mobile']
		]);

		if ($countData > 0) {
			echo json_encode(['return' => false, 'msg' => 'Email/Mobile already exist']);
			return;
		}

		$logo_path = null;
		if (!empty($_FILES['logo']['name'])) {
			$logo = upload_file('logo', 'agency_logo', true, 200, 200, true); 
			if ($logo['status']) {
				$logo_path = $logo['file_path'];
			}
		}

		$array = [
			'name'         => $_POST['name'],
			'email'        => $_POST['email'],
			'password'        => md5($_POST['password']),
			'mobile'       => $_POST['mobile'],
			'address'      => $_POST['address'],
			'markup_type'  => $_POST['markup_type'],
			'markup_value' => $_POST['markup_value'],
			'domain_slug' => strtolower(str_replace(' ', '', $_POST['name'])),
			'logo'         => $logo_path
		];

		if ($this->model->add('agency', $array)) {
			$lead_id = $this->db->insert_id();
			$this->createLog(
				$this->session->userdata('id'),
				$this->session->userdata('role'),
				$lead_id,
				'add',
				'Agency'
			);

			echo json_encode(['return' => true, 'msg' => 'Added Successfully']);
		} else {
			echo json_encode(['return' => false, 'msg' => 'Failed to add']);
		}
	}


	public function viewAgency()
    {
		$data['list'] = $this->model->getResultData('agency',[]);		
		$this->load->view('agency/tb',$data);
    }
	public function editAgency()
    {
        $response=array();
		$data = $this->model->getRowData('agency',['id'=>$_POST['id']]);
		$response = array(
			'id'         => $_POST['id'],
			'name'       => $data['name'],
			'email'      => $data['email'],
			'mobile'     => $data['mobile'],
			'address' => $data['address'],
			'markup_type' => $data['markup_type'],
			'markup_value' => $data['markup_value'],
			'logo' =>base_url('assets/uploads/'.$data['logo'].''),
		);

		echo json_encode($response);
    }
	public function updateAgency()
	{
		$countData = $this->model->countData('agency', [
			'email'  => $_POST['email'],
			'mobile' => $_POST['mobile'],
			'id!='   => $_POST['id']
		]);

		if ($countData > 0) {
			echo json_encode(['return' => false, 'msg' => 'Email/Mobile already exist']);
			return;
		}

		if (isset($_POST['id'])) {
			$array = [
				'name'         => $_POST['name'],
				'email'        => $_POST['email'],
				'mobile'       => $_POST['mobile'],
				'address'      => $_POST['address'],
				'markup_type'  => $_POST['markup_type'],
				'markup_value' => $_POST['markup_value'],
			];

			if (!empty($_FILES['logo']['name'])) {
				$logo = upload_file('logo', 'agency_logo', true, 200, 200, true);

				if ($logo['status']) {
					$new_logo = $logo['file_path'];

					// Get old logo from DB
					$oldData = $this->model->getRowData('agency', ['id' => $_POST['id']]);
					if (!empty($oldData['logo'])) {
						$old_logo_path = FCPATH . 'assets/uploads/' . $oldData['logo'];
						if (file_exists($old_logo_path)) {
							unlink($old_logo_path); 
						}
					}

					$array['logo'] = $new_logo;
				}
			}

			// Update agency
			if ($this->model->edit('agency', $array, ['id' => $_POST['id']])) {
				$lead_id = $_POST['id'];
				$this->createLog(
					$this->session->userdata('id'),
					$this->session->userdata('role'),
					$lead_id,
					'edit',
					'Agency'
				);

				echo json_encode(['return' => true, 'msg' => 'Updated Successfully']);
			} else {
				echo json_encode(['return' => false, 'msg' => 'Update Failed']);
			}
		}
	}

	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('agency',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				echo json_encode(['return' => true, 'msg' => 'Password Changed successfully']);
			}else {
				echo json_encode(['return' => false, 'msg' => 'Password not changed']);
			}
		}
    }
		

	
	public function search_student()
    {
        echo get_students_json();
    }
	
}
