
        <!-- Main Content -->
        <main class="flex-grow">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
                <!-- Page Header -->
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8 gap-4">
                    <div>
                        <h1 class="text-4xl font-bold text-slate-800">Reports & Analytics</h1>
                        <p class="text-slate-500 mt-2">An overview of your business performance.</p>
                    </div>
                    <div class="flex items-center gap-2">
                         <input type="date" class="bg-white border border-slate-300 rounded-md shadow-sm p-2 text-sm focus:ring-sky-500 focus:border-sky-500" value="2025-04-01">
                         <span class="text-slate-500">to</span>
                         <input type="date" class="bg-white border border-slate-300 rounded-md shadow-sm p-2 text-sm focus:ring-sky-500 focus:border-sky-500" value="2025-09-29">
                         <button class="bg-sky-600 text-white font-bold py-2 px-4 rounded-md hover:bg-sky-700 transition-colors text-sm">Apply</button>
                    </div>
                </div>

                <!-- Key Metrics -->
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-sm font-medium text-slate-500">Total Bookings</h3>
                        <p class="mt-2 text-3xl font-bold text-slate-800">128</p>
                        <p class="mt-1 text-sm text-green-600 flex items-center">+5.4% from last period</p>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-sm font-medium text-slate-500">Total Revenue</h3>
                        <p class="mt-2 text-3xl font-bold text-slate-800">₹45,20,500</p>
                        <p class="mt-1 text-sm text-green-600 flex items-center">+12.1% from last period</p>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-sm font-medium text-slate-500">Avg. Commission</h3>
                        <p class="mt-2 text-3xl font-bold text-slate-800">₹35,316</p>
                         <p class="mt-1 text-sm text-red-600 flex items-center">-1.2% from last period</p>
                    </div>
                     <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-sm font-medium text-slate-500">Cancellation Rate</h3>
                        <p class="mt-2 text-3xl font-bold text-slate-800">3.9%</p>
                        <p class="mt-1 text-sm text-green-600 flex items-center">-0.5% from last period</p>
                    </div>
                </div>

                <!-- Charts -->
                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
                    <!-- Booking Revenue Chart -->
                    <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-lg font-bold text-slate-800 mb-4">Booking Revenue</h3>
                        <div class="h-64 bg-slate-50 rounded-md flex items-center justify-center">
                             <!-- Placeholder for chart -->
                             <svg class="w-full h-full text-slate-300" fill="none" viewBox="0 0 24 12" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 11 L5 4 L9 7 L15 2 L19 5 L23 3" stroke="currentColor" stroke-width="0.5" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="5" cy="4" r="0.3" fill="currentColor"/>
                                <circle cx="9" cy="7" r="0.3" fill="currentColor"/>
                                <circle cx="15" cy="2" r="0.3" fill="currentColor"/>
                                <circle cx="19" cy="5" r="0.3" fill="currentColor"/>
                                <circle cx="23" cy="3" r="0.3" fill="currentColor"/>
                            </svg>
                        </div>
                    </div>
                    <!-- Booking Type Chart -->
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <h3 class="text-lg font-bold text-slate-800 mb-4">Booking by Type</h3>
                         <div class="h-64 bg-slate-50 rounded-md flex items-center justify-center">
                             <!-- Placeholder for pie chart -->
                            <svg class="w-40 h-40" viewBox="0 0 36 36">
                                <path d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" fill="#e0f2fe"/>
                                <path d="M18 2.0845 a 15.9155 15.9155 0 0 1 13.929 8.5615 L 18 18 Z" fill="#bae6fd"/>
                                <path d="M31.929 10.646 a 15.9155 15.9155 0 0 1-13.929 23.269 L 18 18 Z" fill="#7dd3fc"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Bookings Table -->
                <div class="bg-white rounded-lg shadow-md border border-slate-200">
                     <div class="p-6 border-b">
                        <h3 class="text-lg font-bold text-slate-800">Recent Transactions</h3>
                    </div>
                    <table class="min-w-full divide-y divide-slate-200">
                        <thead class="bg-slate-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Reference ID</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Details</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Amount</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Status</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-slate-200">
                             <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-sky-700">NH-172839</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800">Hotel Élysées Union</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800 font-semibold">₹2,28,035</td>
                                <td class="px-6 py-4 whitespace-nowrap"><span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-amber-100 text-amber-800">Pending</span></td>
                            </tr>
                             <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-sky-700">NH-KER01-45</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800">Magical Kerala Backwaters</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800 font-semibold">₹49,998</td>
                                <td class="px-6 py-4 whitespace-nowrap"><span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">Confirmed</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </main>
