<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Theme extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    // =========================================
    // INDEX PAGE
    // =========================================
    public function index()
    {
        $data['title'] = 'Themes';
        $page = 'theme/index';
        $this->header_and_footer($page, $data);
    }

    // =========================================
    // ADD THEME
    // =========================================
    public function addTheme()
    {
        $countData = $this->model->countData('themes', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Theme already exists']);
            return;
        }

        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name' => $_POST['name'],
            'slug' => $slug,
        ];

        if ($this->model->add('themes', $array)) {
            $theme_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $theme_id,
                'add',
                'Theme'
            );

            echo json_encode(['return' => true, 'msg' => 'Theme Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add theme']);
        }
    }

    // =========================================
    // VIEW THEMES (TABLE LIST)
    // =========================================
    public function viewTheme()
    {
        $data['list'] = $this->model->getResultData('themes', []); 
        $this->load->view('theme/tb', $data);
    }

    // =========================================
    // EDIT THEME (FETCH DATA)
    // =========================================
    public function editTheme()
    {
        $data = $this->model->getRowData('themes', ['id' => $_POST['id']]);

        $response = [
            'id'   => $data['id'],
            'name' => $data['name'],
            'slug' => $data['slug'],
        ];

        echo json_encode($response);
    }

    // =========================================
    // UPDATE THEME
    // =========================================
    public function updateTheme()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];
        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name' => $_POST['name'],
            'slug' => $slug,
        ];

        if ($this->model->edit('themes', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Theme'
            );

            echo json_encode(['return' => true, 'msg' => 'Theme Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }
}
