<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    // =========================================
    // INDEX PAGE
    // =========================================
    public function index()
    {
        $data['title'] = 'Packages';
        $data['destinations'] = $this->model->getResultData('destinations', ['is_disable'=>0]);
        $data['themes'] = $this->model->getResultData('themes', ['is_disable'=>0]);
        $page = 'package/index';
        $this->header_and_footer($page, $data);
    }

    // =========================================
    // ADD PACKAGE
    // =========================================
    public function addPackage()
    {
        $countData = $this->model->countData('packages', [
            'title' => $_POST['title']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Package with this title already exists']);
            return;
        }

        $slug = strtolower(url_title($_POST['title']));

        // // Handle image upload
        // $image = null;
        // if (!empty($_FILES['image']['name'])) {
        //     $upload = upload_file('image', 'packages');
        //     if ($upload['status']) {
        //         $image = $upload['file_path'];
        //     } else {
        //         echo json_encode(['return' => false, 'msg' => $upload['error']]);
        //         return;
        //     }
        // }

        // Prepare theme IDs as comma-separated string
        $theme_ids = '';
        if (!empty($_POST['themes']) && is_array($_POST['themes'])) {
            $theme_ids = implode(',', $_POST['themes']);
        }

        // Prepare package data
        $array = [
            'destination_id'     => $_POST['destination_id'],
            'title'              => $_POST['title'],
            'slug'               => $slug,
            'duration_nights'    => $_POST['duration_nights'],
            'duration_days'      => $_POST['duration_days'],
            'short_description'  => $_POST['short_description'],
            'itinerary'          => $_POST['itinerary'],
            'hotels'          => $_POST['hotels'],
            'theme_ids'          => $theme_ids,           // comma-separated IDs
            // 'image'              => $image
        ];

        if ($this->model->add('packages', $array)) {
            $package_id = $this->db->insert_id();

            // Log entry
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $package_id,
                'add',
                'Package'
            );

            echo json_encode(['return' => true, 'msg' => 'Package Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add package']);
        }
    }


    // =========================================
    // VIEW PACKAGES (TABLE LIST)
    // =========================================
    public function viewPackage()
    {
        $this->db->select('p.*, d.name as destination_name');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $query = $this->db->get();
        $data['list'] = $query->result_array();

        $this->load->view('package/tb', $data);
    }

    // =========================================
    // EDIT PACKAGE (FETCH DATA)
    // =========================================
public function editPackage()
{
    if (empty($_POST['id'])) {
        echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
        return;
    }

    $data = $this->model->getRowData('packages', ['id' => $_POST['id']]);

    if (!$data) {
        echo json_encode(['return' => false, 'msg' => 'Package not found']);
        return;
    }

    // Convert comma-separated theme_ids to array for frontend checkboxes
    $theme_ids = [];
    if (!empty($data['theme_ids'])) {
        $theme_ids = explode(',', $data['theme_ids']);
    }

    $response = [
        'id'                => $data['id'],
        'destination_id'    => $data['destination_id'],
        'title'             => $data['title'],
        'slug'              => $data['slug'],
        'duration_nights'   => $data['duration_nights'],
        'duration_days'     => $data['duration_days'],
        'short_description' => $data['short_description'],
        // 'image'             => $data['image'],
        'itinerary'         => $data['itinerary'],
        'hotels'          => $data['hotels'],
        'themes'            => $theme_ids // ✅ array of IDs for checkbox selection
    ];

    echo json_encode($response);
}


    // =========================================
    // UPDATE PACKAGE
    // =========================================
public function updatePackage()
{
    if (!isset($_POST['id']) || empty($_POST['id'])) {
        echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
        return;
    }

    $id = $_POST['id'];
    $slug = strtolower(url_title($_POST['title']));

    // Fetch existing package data
    $package = $this->model->getRowData('packages', ['id' => $id]);
    $image = $package['image'];

    // // Handle new image upload
    // if (!empty($_FILES['image']['name'])) {
    //     $upload = upload_file('image', 'packages');
    //     if ($upload['status']) {
    //         $image = $upload['file_path'];
    //     } else {
    //         echo json_encode(['return' => false, 'msg' => $upload['error']]);
    //         return;
    //     }
    // }

    // Handle theme_ids (checkbox array)
    $theme_ids = '';
    if (!empty($_POST['themes'])) {
        $theme_ids = implode(',', $_POST['themes']);
    }

    // Handle itinerary (text editor input)
    $itinerary = isset($_POST['itinerary']) ? trim($_POST['itinerary']) : '';

    $array = [
        'destination_id'     => $_POST['destination_id'],
        'title'              => $_POST['title'],
        'slug'               => $slug,
        'duration_nights'    => $_POST['duration_nights'],
        'duration_days'      => $_POST['duration_days'],
        'short_description'  => $_POST['short_description'],
        // 'image'              => $image,
        'theme_ids'          => $theme_ids,
        'itinerary'          => $itinerary,
        'hotels'          => $_POST['hotels'],
    ];

    if ($this->model->edit('packages', $array, ['id' => $id])) {
        $this->createLog(
            $this->session->userdata('id'),
            $this->session->userdata('role'),
            $id,
            'edit',
            'Package'
        );

        echo json_encode(['return' => true, 'msg' => 'Package Updated Successfully']);
    } else {
        echo json_encode(['return' => false, 'msg' => 'Update Failed']);
    }
}







	public function packageImage()
    {
		$data['list'] = $this->package_model->packageImage($_POST['package_id']);
    }
	public function deletePackageImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->package_model->deletePackageImage($_POST['image_id']))
			{
				$lead_id = $_POST['image_id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','package image');
				echo json_encode(['return'=>true,'msg'=>'Image Deleted Successfully']);
			}
		}
    }
	public function addPackageImage()
    {
        if($_POST['package_id'])
		{
			if($this->package_model->addPackageImage($_POST['package_id']))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','package image');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function makePackageCoverImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->model->edit('package_image',['is_cover'=>0],['package_id'=>$_POST['package_id']]))
			{
				$this->model->edit('package_image',['is_cover'=>1],['id'=>$_POST['image_id']]);
				
				echo json_encode(['return'=>true,'msg'=>'Cover Updated Successfully']);
			}
		}
    }

}
