
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        /* Custom styles for range input */
        input[type=range]::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 16px;
            height: 16px;
            background: #0ea5e9; /* sky-500 */
            cursor: pointer;
            border-radius: 50%;
            margin-top: -6px;
        }

        input[type=range]::-moz-range-thumb {
            width: 16px;
            height: 16px;
            background: #0ea5e9;
            cursor: pointer;
            border-radius: 50%;
        }
    </style>

        <!-- Main Content -->
        <main class="flex-grow">

            <!-- Results Content -->
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
                <div class="flex flex-col lg:flex-row gap-8">
                   

                    <!-- Search Results -->
                    <div class="w-full lg:w-4/4">
                        <!-- Sorting and View Options -->
                        <div class="flex flex-col sm:flex-row justify-between items-center mb-4">
                            <h2 class="text-xl font-bold text-slate-700 mb-2 sm:mb-0">Showing <?= count($hotels); ?> hotels</h2>
                            <!-- <div>
                                <label for="sort_by" class="text-sm font-medium mr-2">Sort by:</label>
                                <select id="sort_by" class="rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                    <option>Recommended</option>
                                    <option>Price (Low to High)</option>
                                    <option>Price (High to Low)</option>
                                    <option>Guest Rating</option>
                                </select>
                            </div> -->
                        </div>

                        <!-- Hotel List -->
                        <div class="space-y-6">
                            <?php if(!empty($hotels)) : ?>
                                <?php foreach($hotels as $hotel): ?>
                                    <div class="bg-white rounded-lg shadow-md border border-slate-200 flex flex-col md:flex-row overflow-hidden hover:shadow-xl transition-shadow duration-300">
                                        <div class="md:w-1/3">
                                            <?php 
                                            $logo_path = 'assets/uploads/' . $hotel['logo']; 
                                            if(!empty($hotel['logo']) && file_exists(FCPATH . $logo_path)) {
                                                $img_src = base_url($logo_path);
                                            } else {
                                                $img_src = base_url('assets/img/default-hotel.png'); // your default image
                                            }
                                            ?>
                                            <img src="<?= $img_src; ?>" alt="<?= $hotel['name']; ?>" class="w-full h-full object-cover">

                                        </div>
                                        <div class="p-6 flex flex-col justify-between md:w-2/3">
                                            <div>
                                                <div class="flex justify-between items-start">
                                                    <div>
                                                        <h3 class="text-2xl font-bold text-slate-800"><?= $hotel['name']; ?></h3>
                                                        <p class="text-sm text-slate-500 mb-2"><?= $hotel['address']; ?>, <?= $hotel['city']; ?></p>
                                                    </div>
                                                    <div class="flex flex-col items-end">
                                                        <!-- <div class="bg-sky-600 text-white font-bold text-lg rounded-md px-3 py-1"><?= rand(7,9).'.'.rand(0,9); ?></div>
                                                        <p class="text-xs text-slate-500"><?= rand(100,5000); ?> reviews</p> -->
                                                    </div>
                                                </div>
                                                <div class="flex items-center my-2">
                                                    <!-- <span class="text-yellow-400"><?= str_repeat('★', rand(3,5)); ?></span> -->
                                                    <span class="text-xs text-slate-500 ml-2"><?= $hotel['type']; ?></span>
                                                </div>
                                                <p class="text-sm text-slate-600 mb-4"><?= $hotel['description']; ?></p>
                                                <p class="text-xs text-slate-500"><strong>Amenities:</strong> <?= $hotel['amenities']; ?></p>
                                            </div>
                                            <div class="border-t pt-4 mt-4 flex flex-col sm:flex-row justify-between items-center">
                                                <div>
                                                </div>
                                                <!-- <a href="<?= base_url('hotel-details/'.$hotel['id'].''); ?>" class="w-full sm:w-auto mt-4 sm:mt-0 bg-orange-500 hover:bg-orange-600 text-white font-bold py-3 px-6 rounded-md transition-colors text-center">View Rooms</a> -->
                                                 <form action="<?= base_url('hotel-details/' . $hotel['id']); ?>" method="post" class="inline-block">
                                                    <input type="hidden" name="checkin" value="<?= $checkin; ?>">
                                                    <input type="hidden" name="checkout" value="<?= $checkout; ?>">

                                                    <button type="submit"
                                                        class="w-full sm:w-auto mt-4 sm:mt-0 bg-orange-500 hover:bg-orange-600 text-white font-bold py-3 px-6 rounded-md transition-colors text-center">
                                                        View Rooms
                                                    </button>
                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p>No hotels found.</p>
                            <?php endif; ?>
                        </div>

                        <!-- Pagination -->
                        <!-- <div class="flex justify-center mt-10">
                             <nav class="inline-flex rounded-md shadow-sm -space-x-px" aria-label="Pagination">
                                <a href="#" class="relative inline-flex items-center px-2 py-2 rounded-l-md border border-slate-300 bg-white text-sm font-medium text-slate-500 hover:bg-slate-50">
                                    <span class="sr-only">Previous</span>
                                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" /></svg>
                                </a>
                                <a href="#" aria-current="page" class="z-10 bg-sky-50 border-sky-500 text-sky-600 relative inline-flex items-center px-4 py-2 border text-sm font-medium"> 1 </a>
                                <a href="#" class="bg-white border-slate-300 text-slate-500 hover:bg-slate-50 relative inline-flex items-center px-4 py-2 border text-sm font-medium"> 2 </a>
                                <a href="#" class="bg-white border-slate-300 text-slate-500 hover:bg-slate-50 hidden md:inline-flex relative items-center px-4 py-2 border text-sm font-medium"> 3 </a>
                                <span class="relative inline-flex items-center px-4 py-2 border border-slate-300 bg-white text-sm font-medium text-slate-700"> ... </span>
                                <a href="#" class="bg-white border-slate-300 text-slate-500 hover:bg-slate-50 hidden md:inline-flex relative items-center px-4 py-2 border text-sm font-medium"> 8 </a>
                                <a href="#" class="relative inline-flex items-center px-2 py-2 rounded-r-md border border-slate-300 bg-white text-sm font-medium text-slate-500 hover:bg-slate-50">
                                    <span class="sr-only">Next</span>
                                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" /></svg>
                                </a>
                            </nav>
                        </div> -->
                    </div>
                </div>
            </div>
        </main>
