<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          aaSorting: [[0, 'desc']],
        buttons: [
        //  { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          //{ extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
         // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]
        });
      }else{
        $('#mytable').DataTable({
          aaSorting: [[0, 'desc']],
        });
      }
        if($('#usertype').val() == 'staff')
        {
            $('.edit-btn').remove();
            $('.add-btn').remove();
        }
    } );
</script>
<table class="table table-striped table-hover" id="propertyTable">
    <thead>
        <tr>
            <th scope="col">S.No.</th>
            <th scope="col">Property Name</th>
            <th scope="col">Type</th>
            <th scope="col">Address</th>
            <th scope="col">City</th>
            <th scope="col">State</th>
            <th scope="col">Country</th>
            <th scope="col">Logo</th>
            <th scope="col">Google Map</th>
            <th scope="col">Date</th>
            <th scope="col">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1; foreach($list as $val) { ?>
        <tr>
            <th scope="row"><?= $i++; ?></th>
            <td><?= $val['name']; ?></td>
            <td><?= ucfirst($val['type']); ?></td>
            <td><?= $val['address']; ?></td>
            <td><?= $val['city_name']; ?></td>
            <td><?= $val['state_name']; ?></td>
            <td><?= $val['country_name']; ?></td>

            <td>
                <?php if (!empty($val['logo'])) { ?>
                    <div class="d-flex align-items-center gap-2">
                        <!-- Thumbnail -->
                        <img src="<?= base_url('assets/uploads/'.$val['logo']); ?>" alt="Logo" width="40" height="40" class="rounded border">

                        <!-- Action icons -->
                        <div class="d-flex flex-column">
                            <a href="<?= base_url('assets/uploads/'.$val['logo']); ?>" target="_blank" title="View">
                                <i class="bi bi-eye text-primary" style="font-size: 1.2rem;"></i>
                            </a>
                            <a href="<?= base_url('assets/uploads/'.$val['logo']); ?>" download title="Download">
                                <i class="bi bi-download text-success" style="font-size: 1.2rem;"></i>
                            </a>
                        </div>
                    </div>
                <?php } else { ?>
                    <span class="text-muted">No Logo</span>
                <?php } ?>
            </td>

            <td>
                <?php if (!empty($val['google_map_link'])): ?>
                    <a href="<?= $val['google_map_link']; ?>" target="_blank">View Map</a>
                <?php else: ?>
                    <span class="text-muted">N/A</span>
                <?php endif; ?>
            </td>

            <td><?= date('d-m-Y', strtotime($val['created'])); ?></td>

            <td>
                <a href="javascript:void(0)" class="btn btn-info btn-sm edit-btn"
                   onclick="editData(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editModal">Edit</a>
                <?php if ($val['is_disable'] == '0') { ?>
                    <a href="javascript:void(0)" class="btn btn-danger btn-sm"
                       onclick="changeStatus(<?= $val['id']; ?>, '1')">Disable</a>
                <?php } else { ?>
                    <a href="javascript:void(0)" class="btn btn-success btn-sm"
                       onclick="changeStatus(<?= $val['id']; ?>, '0')">Enable</a>
                <?php } ?>
                <a href="javascript:void(0)" 
                    class="btn btn-danger btn-sm"
                    onclick="deleteRecord(<?= $val['id']; ?>, 'properties')">
                    Delete
                </a>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>





<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'agency';
    var column = 'is_disable';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'role'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('agency/viewAgency/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};
</script>