
  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="add-form">  
                  <div class="col-md-12">
                    <label class="form-label">Property Name</label>
                    <input type="text" class="form-control" id="name" name="name" required>
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Property Type</label>
                    <select class="form-control" id="type" name="type" required>
                      <option value="">Select Type</option>
                      <option value="hotel">Hotel</option>
                      <option value="villa">Villa</option>
                      <option value="apartment">Apartment</option>
                      <option value="resort">Resort</option>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Logo</label>
                    <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Address</label>
                    <textarea class="form-control" id="address" name="address"></textarea>
                  </div>

                  <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                        <option value="">Select Country</option>
                        <?php foreach($countries as $country){ ?>
                          <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">State</label>
                    <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                    </select>                    
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">City</label>
                    <select name="city" class="city form-control" id="city">
                    </select>                 
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Google Map Link</label>
                    <input type="url" class="form-control" id="google_map_link" name="google_map_link">
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Description</label>
                    <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                  </div>


                  <div class="col-12 text-left">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </form>

              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
               <form class="row g-3" id="edit-form" >
                <div class="col-md-12">
                    <label class="form-label">Property Name</label>
                    <input type="text" class="form-control" id="e_name" name="name" required>
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Property Type</label>
                    <select class="form-control" id="e_type" name="type" required>
                      <option value="">Select Type</option>
                      <option value="hotel">Hotel</option>
                      <option value="villa">Villa</option>
                      <option value="apartment">Apartment</option>
                      <option value="resort">Resort</option>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Logo</label>
                    <input type="file" class="form-control" id="e_logo" name="logo" accept="image/*">
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Address</label>
                    <textarea class="form-control" id="e_address" name="address"></textarea>
                  </div>

                  <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                        <option value="">Select Country</option>
                        <?php foreach($countries as $country){ ?>
                          <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">State</label>
                    <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
                    </select>                    
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">City</label>
                    <select name="city" class="city form-control" id="e_city">
                    </select>                 
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Google Map Link</label>
                    <input type="url" class="form-control" id="e_google_map_link" name="google_map_link">
                  </div>

                  <div class="col-md-12">
                    <label class="form-label">Description</label>
                    <textarea class="form-control" id="e_description" name="description" rows="3"></textarea>
                  </div>


                <div class="col-12 text-left">
                  <input type="hidden" id="e_id" name="id">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>

              </div>
            </div>
          </div>
        </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('property/viewProperty'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('property/addProperty'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('property/viewProperty'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('property/editProperty'); ?>",
      method: "POST",
      dataType: 'json',
      data: {
          id: id
      },
      success: function(res) {
          $("#e_id").val(res.id);
          $("#e_country").val(res.country);
          $("#e_name").val(res.name);
          $("#e_type").val(res.type);
          $("#e_description").val(res.description);
          $("#e_address").val(res.address);
          if (res.logo) {
            $("#e_logo").after('<img src="' + res.logo + '" alt="Logo" class="mt-2" width="80">');
          }

          $("#e_google_map_link").val(res.google_map_link);
          fetch_state(res.country,res.state);
          fetch_city(res.state,res.city);

      }
  });
}

$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('property/updateProperty'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('property/viewProperty'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
});

function fetch_state(country_id,state_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_state'); ?>",
    method: "POST",
    data: {
      country_id: country_id,
      state_id: state_id
    },
    success: function(data) {
      if(state_id == null)
      {
        $(".state").html(data);
      }
      else
      {
        $("#e_state").html(data);
      }
    },
  });
}
function fetch_city(state_id,city_id) {
  $.ajax({
    url: "<?= base_url('dashboard/fetch_city'); ?>",
    method: "POST",
    data: {
      state_id: state_id,
      city_id: city_id
    },
    success: function(data) {
      if(city_id == null)
      {
        $(".city").html(data);
      }
      else
      {
        $("#e_city").html(data);
      }
    },
  });
}
</script>

