<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <!-- Select Destination -->
          <div class="col-md-6">
            <label for="destination_id">Select Destination</label>
            <select class="form-control" id="destination_id" name="destination_id" required>
              <option value="">Select Destination</option>
              <?php foreach ($destinations as $dest): ?>
                <option value="<?= $dest['id']; ?>"><?= $dest['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Package Name -->
          <div class="col-md-6">
            <label for="package_name">Package Name</label>
            <input type="text" class="form-control" id="package_name" name="package_name" placeholder="Enter Package Name" required>
          </div>

          <!-- Package Code -->
          <div class="col-md-6">
            <label for="package_code">Package Code</label>
            <input type="text" class="form-control" id="package_code" name="package_code" placeholder="Enter Package Code" required>
          </div>

          <!-- Nights / Days -->
          <div class="col-md-3">
            <label for="nights">Nights</label>
            <input type="number" class="form-control" id="nights" name="nights" placeholder="e.g. 5" required>
          </div>

          <div class="col-md-3">
            <label for="days">Days</label>
            <input type="number" class="form-control" id="days" name="days" placeholder="e.g. 6" required>
          </div>

          <!-- Price -->
          <div class="col-md-6">
            <label for="price">Price (₹ per person)</label>
            <input type="number" class="form-control" id="price" name="price" placeholder="e.g. 24999" required>
          </div>

          <!-- Themes (Multiple Select) -->
          <div class="col-md-6">
            <label for="themes">Select Themes</label>
            <select class="form-control" id="themes" name="themes[]" multiple>
              <?php foreach ($themes as $theme): ?>
                <option value="<?= $theme['id']; ?>"><?= $theme['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Inclusions (Multiple Select) -->
          <div class="col-md-12">
            <label for="inclusions">Inclusions</label>
            <select class="form-control" id="inclusions" name="inclusions[]" multiple>
              <?php foreach ($inclusions as $inc): ?>
                <option value="<?= $inc['id']; ?>"><?= $inc['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Status -->
          <div class="col-md-6">
            <label for="status">Status</label>
            <select class="form-control" id="status" name="status">
              <option value="available">Available</option>
              <option value="unavailable">Unavailable</option>
            </select>
          </div>

          <!-- Submit / Reset -->
          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save Package</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>

      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <div class="col-md-6">
            <label for="e_property_id">Select Property</label>
            <select class="form-control" id="e_property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label for="e_name">Room Name</label>
            <input type="text" class="form-control" id="e_name" name="name" required>
          </div>

          <div class="col-md-12">
            <label for="e_description">Description</label>
            <textarea class="form-control" id="e_description" name="description" rows="3"></textarea>
          </div>

          <div class="col-md-4">
            <label for="e_capacity">Capacity</label>
            <input type="number" class="form-control" id="e_capacity" name="capacity" required>
          </div>

          <div class="col-md-4">
            <label for="e_bed_type">Bed Type</label>
            <select class="form-control" id="e_bed_type" name="bed_type" required>
              <option value="single">Single</option>
              <option value="double">Double</option>
              <option value="queen">Queen</option>
              <option value="king">King</option>
              <option value="twin">Twin</option>
              <option value="bunk">Bunk</option>
            </select>
          </div>

          <div class="col-md-4">
            <label for="e_size_sqft">Size (sqft)</label>
            <input type="number" class="form-control" id="e_size_sqft" name="size_sqft">
          </div>

          <div class="col-md-6">
            <label for="e_status">Status</label>
            <select class="form-control" id="e_status" name="status">
              <option value="available">Available</option>
              <option value="unavailable">Unavailable</option>
            </select>
          </div>

          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<script>
function addPackage() {
  $('#addPackageModal').modal('show'); 
  $('#add-package-form')[0].reset();
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('packages/viewPackages'); ?>');
});

// Add Package
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('packages/add'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#addPackageModal').modal('hide'); 
        $('#add-package-form')[0].reset();
        $('#tb').load('<?= base_url('packages/viewPackages'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Edit Package
function editPackage(id) {
  $.ajax({
    url: "<?= base_url('packages/edit/'); ?>" + id,
    method: "GET",
    dataType: 'json',
    success: function(res) {
      if(res.return === false){
        toastr.error(res.msg);
        return;
      }
      $("#e_id").val(res.id);
      $("#e_destination_id").val(res.destination_id);
      $("#e_package_name").val(res.package_name);
      $("#e_package_code").val(res.package_code);
      $("#e_nights").val(res.nights);
      $("#e_days").val(res.days);
      $("#e_price").val(res.price);
      $("#e_status").val(res.status);

      // Set multiple select values for themes & inclusions
      $("#e_themes").val(res.themes).trigger('change');
      $("#e_inclusions").val(res.inclusions).trigger('change');

      $('#editPackageModal').modal('show');
    }
  });
}

// Update Package
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  let id = $("#e_id").val();
  $.ajax({
    url: "<?= base_url('packages/update/'); ?>" + id,
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#editPackageModal').modal('hide'); 
        $('#edit-package-form')[0].reset();
        $('#tb').load('<?= base_url('packages/viewPackages'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
})

// Delete Package
function deletePackage(id){
  if(confirm("Are you sure you want to delete this package?")){
    $.ajax({
      url: "<?= base_url('packages/delete/'); ?>" + id,
      method: "POST",
      dataType: "json",
      success:function(res){
        if(res.return){
          $('#tb').load('<?= base_url('packages/viewPackages'); ?>');
          toastr.success(res.msg);
        } else {
          toastr.error(res.msg);
        }
      }
    });
  }
}
</script>
