<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          aaSorting: [[0, 'desc']],
        buttons: [
        //  { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          //{ extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
         // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]
        });
      }else{
        $('#mytable').DataTable({
          aaSorting: [[0, 'desc']],
        });
      }
        if($('#usertype').val() == 'staff')
        {
            $('.edit-btn').remove();
            $('.add-btn').remove();
        }
    } );
</script>
<table class="table table-striped table-bordered align-middle">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Package</th>
            <th>Destination</th>
            <th>Dates</th>
            <th>Travelers</th>
            <th>Price (₹)</th>
            <th>Agent Info</th>
            <th>Itinerary Details</th>
            <th>Status</th>
            <th>Created</th>
        </tr>
    </thead>
    <tbody>
        <?php $i=1; foreach($list as $val): ?>
        <tr>
            <td><?= $i++; ?></td>
            <td><strong><?= $val['package_name']; ?></strong></td>
            <td><?= $val['destination_name'] ?? '-'; ?></td>

            <td>
                <div><i class="bi bi-calendar-event"></i>
                    <?= date("d M Y", strtotime($val['start_date'])); ?>
                    <?php if(!empty($val['end_date'])): ?>
                        → <?= date("d M Y", strtotime($val['end_date'])); ?>
                    <?php endif; ?>
                </div>
                <small class="text-muted"><?= $val['no_of_days']; ?> days</small>
            </td>

            <td>
                <?= $val['no_of_adults']; ?> Adults
                <?php if($val['no_of_children'] > 0): ?>
                    / <?= $val['no_of_children']; ?> Children
                <?php endif; ?>
            </td>

            <td>
                <strong>Subtotal:</strong> ₹<?= number_format($val['subtotal']); ?><br>
                <strong>Total:</strong> ₹<?= number_format($val['total']); ?>
            </td>

            <td>
                <div><?= $val['agent_name'] ?? 'N/A'; ?></div>
                <small class="text-muted">
                    <?= $val['email'] ?? ''; ?><br>
                    <?= $val['mobile'] ?? ''; ?>
                </small>
            </td>

            <td>
                <?php if(!empty($val['items'])): ?>
                    <ul class="list-group list-group-flush small">
                        <?php foreach($val['items'] as $item): ?>
                        <li class="list-group-item px-2 py-1">
                            <strong><?= $item['city_name']; ?></strong> - <?= $item['hotel_name']; ?><br>
                            <?= $item['room_name']; ?> (<?= $item['nights']; ?> nights)
                            <span class="float-end text-success">₹<?= number_format($item['total_price']); ?></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <span class="text-muted">No itinerary found</span>
                <?php endif; ?>
            </td>

            <td>
                <?php
                    $status_colors = [
                        'pending' => 'warning',
                        'confirmed' => 'success',
                        'cancelled' => 'danger',
                        'payment_received' => 'info'
                    ];
                    $status_class = $status_colors[$val['status']] ?? 'secondary';
                ?>
                <span class="badge bg-<?= $status_class; ?>"><?= ucfirst($val['status']); ?></span>

                <select class="form-select form-select-sm mt-1 status-dropdown"
                        data-id="<?= $val['id']; ?>">
                    <option value="pending" <?= $val['status']=='pending'?'selected':''; ?>>Pending</option>
                    <option value="confirmed" <?= $val['status']=='confirmed'?'selected':''; ?>>Confirmed</option>
                    <option value="payment_received" <?= $val['status']=='payment_received'?'selected':''; ?>>Payment Received</option>
                    <option value="cancelled" <?= $val['status']=='cancelled'?'selected':''; ?>>Cancelled</option>
                </select>
            </td>

            <td><?= date("d-M-Y", strtotime($val['created_at'])); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>







<script>



$(document).ready(function(){
    $('.status-dropdown').change(function(){
        var inquiryId = $(this).data('id');
        var newStatus = $(this).val();

        $.ajax({
            url: "<?php echo base_url('custom_inquiry/update_inquiry_status'); ?>",
            method: "POST",
            data: {
                id: inquiryId,
                status: newStatus
            },
            dataType:'json',
            success:function(res){
              if(res.return)
              {
                $('#tb').load('<?= base_url('custom_inquiry/viewCustomInquiry'); ?>');
                toastr.success(res.msg);
              }
              else
              {
                toastr.error(res.msg);
              }
              
            }
        });
    });
});
</script>