<style>
    body { font-family: 'Inter', sans-serif; }
    .tab-active { border-color: #0ea5e9; color: #0ea5e9; }
</style>

<main class="flex-grow">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">

        <!-- Package Header -->
        <div>
            <h1 class="text-4xl font-bold text-slate-800"><?= $package_data['title'] ?? 'Package Title'; ?></h1>
            <div class="flex items-center space-x-4 text-slate-500 mt-2">
                <span><?= ($package_data['duration_nights'] ?? 0); ?> Nights / <?= ($package_data['duration_days'] ?? 0); ?> Days</span>
                <span class="text-slate-300">|</span>
                <span>
                    <?php 
                        $theme_names = array_map(fn($t) => $t['name'] ?? '', $package_data['themes'] ?? []);
                        $theme_names = array_filter($theme_names); // remove empty
                        echo $theme_names ? implode(", ", $theme_names) : 'No Themes';
                    ?>
                </span>
                <span class="text-slate-300">|</span>
            </div>
        </div>

        <?php
        $images = get_package_images($package_data['package_id']);
        ?>

        <!-- Image Gallery -->
        <div class="mt-6 grid grid-cols-4 grid-rows-2 gap-2 h-96">
            <!-- Main Cover Image -->
            <div class="col-span-2 row-span-2 rounded-lg overflow-hidden bg-gray-100">
                <?php if (!empty($images['cover'])): ?>
                    <img src="<?= $images['cover'] ?>" 
                        onerror="this.onerror=null;this.src='<?= base_url('assets/images/no-image.jpg') ?>';"
                        class="w-full h-full object-cover">
                <?php else: ?>
                    <div class="flex items-center justify-center w-full h-full bg-gray-200 text-gray-500 text-lg font-medium">
                        No Image
                    </div>
                <?php endif; ?>
            </div>


            <!-- Gallery Images -->
            <?php 
            if (!empty($images['gallery'])): 
                foreach ($images['gallery'] as $img): ?>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden">
                        <img src="<?= $img ?>" class="w-full h-full object-cover">
                    </div>
                <?php endforeach;
            else: ?>
                <!-- Placeholder if no images -->
                <?php for($i=1; $i<=4; $i++): ?>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden">
                        <img src="https://placehold.co/400x400/cccccc/000000?text=No+Image+<?= $i ?>" class="w-full h-full object-cover">
                    </div>
                <?php endfor; ?>
            <?php endif; ?>
        </div>


        <div class="mt-8 flex flex-col lg:flex-row gap-8">
            <!-- Left Column -->
            <div class="w-full lg:w-2/3">
                <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">

                    <!-- Tabs Navigation -->
                    <div class="border-b border-slate-200">
                        <nav class="-mb-px flex space-x-8" id="tabs">
                            <button class="tab-active whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm" data-tab="itinerary">Itinerary</button>
                            <button class="text-slate-500 hover:text-slate-700 whitespace-nowrap py-4 px-1 border-b-2 border-transparent font-medium text-sm" data-tab="inclusions">Inclusions</button>
                            <button class="text-slate-500 hover:text-slate-700 whitespace-nowrap py-4 px-1 border-b-2 border-transparent font-medium text-sm" data-tab="hotels">Hotels</button>
                        </nav>
                    </div>

                    <!-- Tabs Content -->
                    <div class="py-6 space-y-8">
                        <!-- Itinerary -->
                        <div class="tab-content" id="itinerary">
                            <?php
                            $itinerary_text = trim($package_data['itinerary'] ?? '');

                            if ($itinerary_text):

                                // Normalize spaces
                                $itinerary_text = preg_replace('/\s+/', ' ', $itinerary_text);

                                // Split by "Day X:" pattern
                                preg_match_all('/Day\s+\d+(?:-\d+)?:.*?(?=Day\s+\d+(?:-\d+)?:|$)/i', $itinerary_text, $matches);

                                $days = $matches[0];

                                foreach ($days as $index => $day):

                                    preg_match('/^(Day\s+\d+(?:-\d+)?):\s*(.*)$/i', $day, $parts);

                                    $day_title = $parts[1] ?? 'Day';
                                    $day_desc  = $parts[2] ?? '';
                            ?>
                                <div class="flex gap-4 mb-6">
                                    <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">
                                            <?= $index + 1 ?>
                                        </div>
                                        <?php if ($index < count($days) - 1): ?>
                                            <div class="w-px h-full bg-slate-200 mt-2"></div>
                                        <?php endif; ?>
                                    </div>

                                    <div>
                                        <h3 class="text-lg font-bold"><?= htmlspecialchars($day_title) ?></h3>
                                        <p class="text-slate-600 mt-1"><?= htmlspecialchars($day_desc) ?></p>
                                    </div>
                                </div>
                            <?php
                                endforeach;
                            else:
                                echo "<p class='text-slate-500'>No itinerary available.</p>";
                            endif;
                            ?>
                        </div>


                        <!-- Inclusions -->
                        <div class="tab-content hidden" id="inclusions">
                            <?php if(!empty($package_data['inclusions'])): ?>
                                <ul class="list-disc pl-5 space-y-2 text-slate-600">
                                    <?php foreach($package_data['inclusions'] as $inc): ?>
                                        <li><?= $inc['inclusion_text'] ?? ''; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <p class="text-slate-500">No inclusions available.</p>
                            <?php endif; ?>
                        </div>

                        <!-- Hotels -->
                        <div class="tab-content hidden" id="hotels">
                            <?php
                                $hotels_text = $package_data['hotels'] ?? '';
                                if($hotels_text):
                                    $hotels = preg_split("/\r\n|\r|\n/", $hotels_text);
                            ?>
                                <ul class="list-disc pl-5 space-y-2 text-slate-600">
                                    <?php foreach($hotels as $hotel):
                                        $hotel = trim($hotel);
                                        if($hotel) echo "<li>{$hotel}</li>";
                                    endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <p class="text-slate-500">No hotels information available.</p>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <aside class="w-full lg:w-1/3">
                <div class="sticky top-24">
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <p class="text-sm text-slate-500">Starts from</p>
                        <p id="package_price" class="text-4xl font-bold text-orange-600 mt-2">
                            ₹<?= get_lowest_price('package', $package_data['package_id'])['price_with_markup']; ?> 
                            <span class="text-lg font-normal text-slate-500">/ person</span>
                        </p>
                        <!-- <p class="text-4xl font-bold text-orange-600">₹<?= get_lowest_price('package', $package_data['package_id']); ?> <span class="text-lg font-normal text-slate-500">/ person</span></p> -->
                        
                        <div class="border-t my-4"></div>
                        
                        <div class="space-y-4">
                            <!-- <div>
                                <label for="travel_date" class="block text-sm font-medium text-slate-600">Travel Date</label>
                                <input type="date" id="travel_date" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm sm:text-sm">
                            </div> -->
                            <div>
                                <label for="travel_date" class="block text-sm font-medium text-slate-600">Travel Date</label>
                                <input type="date" id="travel_date" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm sm:text-sm">
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="adults" class="block text-sm font-medium text-slate-600">Adults</label>
                                    <input type="number" id="adults" value="2" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm sm:text-sm">
                                </div>
                                <div>
                                    <label for="children" class="block text-sm font-medium text-slate-600">Children</label>
                                    <input type="number" id="children" value="0" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm sm:text-sm">
                                </div>
                            </div>
                        </div>

                        <div class="border-t my-4"></div>
                        <!-- <div class="flex justify-between items-center">
                            <span class="text-lg font-bold">Estimated Total</span>
                            <span class="text-2xl font-bold text-slate-800">₹<?= number_format(($package_data['price'] ?? 0)*2,0); ?></span>
                        </div> -->

                        <div class="mt-4">
                            <label for="enquiry_message" class="block text-sm font-medium text-slate-600">Message (optional)</label>
                            <textarea id="enquiry_message" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm sm:text-sm" rows="3"></textarea>
                        </div>

                        <button id="send_enquiry" class="mt-2 w-full border border-slate-300 bg-white hover:bg-slate-50 text-slate-700 font-bold py-2 px-4 rounded-lg transition-colors">
                            Send Enquiry
                        </button>

                    </div>
                </div>
            </aside>
        </div>

    </div>
</main>

<script>
    // Tabs functionality
    const tabs = document.querySelectorAll('#tabs button');
    const contents = document.querySelectorAll('.tab-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            tabs.forEach(t => t.classList.remove('tab-active'));
            tab.classList.add('tab-active');

            const target = tab.dataset.tab;
            contents.forEach(c => c.id === target ? c.classList.remove('hidden') : c.classList.add('hidden'));
        });
    });

    
</script>

<script>
$(document).ready(function(){

    // $('#send_enquiry').on('click', function(){
    //     // Get values
    //     var package_id = <?= $package_data['package_id'] ?? 0; ?>;
    //     var travel_date = $('#travel_date').val();
    //     var adults = parseInt($('#adults').val()) || 0;
    //     var children = parseInt($('#children').val()) || 0;
    //     var travelers = adults + children;
    //     var message = $('#enquiry_message').val();

    //     if(!package_id) {
    //         alert('Invalid package ID');
    //         return;
    //     }

    //     if(travelers <= 0) {
    //         alert('Please enter at least one traveler');
    //         return;
    //     }

    //     $.ajax({
    //         url: "<?= base_url('website/send_package_inquiry'); ?>",
    //         method: "POST",
    //         dataType: 'json',
    //         data: {
    //             package_id: package_id,
    //             travel_date: travel_date,
    //             adults: adults,
    //             children: children,
    //             travelers: travelers,
    //             message: message,
    //             price: "<?= get_current_month_prices('package',$package_data['package_id'])[0]; ?>"
    //         },
    //         success: function(res){
    //             if(res.status == 'success') {
    //                 alert('Inquiry sent successfully!');
    //                 // optionally reset fields
    //                 $('#travel_date').val('');
    //                 $('#adults').val(2);
    //                 $('#children').val(0);
    //                 $('#enquiry_message').val('');
    //             } else {
    //                 alert(res.message || 'Failed to send inquiry');
    //             }
    //         },
    //         error: function(xhr, status, error){
    //             alert('Something went wrong. Please try again.');
    //         }
    //     });
    // });

    $('#send_enquiry').on('click', function(){
    var package_id = <?= $package_data['package_id'] ?? 0; ?>;
    var travel_date = $('#travel_date').val();
    var adults = parseInt($('#adults').val()) || 0;
    var children = parseInt($('#children').val()) || 0;
    var travelers = adults + children;
    var message = $('#enquiry_message').val();

    if(!package_id) {
        alert('Invalid package ID');
        return;
    }

    if(!travel_date) {
        alert('Please select a travel date');
        return;
    }

    if(travelers <= 0) {
        alert('Please enter at least one traveler');
        return;
    }

    // 🔹 Step 1: Fetch price based on travel date
    $.ajax({
        url: "<?= base_url('website/get_price_by_date'); ?>",
        method: "POST",
        dataType: "json",
        data: {
            type: 'package',
            id: package_id,
            date: travel_date
        },
        success: function(priceRes) {
            if (priceRes.status) {
                var price = priceRes.price;

                // 🔹 Step 2: Now send the enquiry with price
                $.ajax({
                    url: "<?= base_url('website/send_package_inquiry'); ?>",
                    method: "POST",
                    dataType: 'json',
                    data: {
                        package_id: package_id,
                        travel_date: travel_date,
                        adults: adults,
                        children: children,
                        travelers: travelers,
                        message: message,
                        price: price
                    },
                    success: function(res){
                        if(res.status == 'success') {
                            alert('Inquiry sent successfully!');
                            $('#travel_date').val('');
                            $('#adults').val(2);
                            $('#children').val(0);
                            $('#enquiry_message').val('');
                        } else {
                            alert(res.message || 'Failed to send inquiry');
                        }
                    },
                    error: function(xhr, status, error){
                        alert('Something went wrong. Please try again.');
                    }
                });

            } else {
                alert('Could not fetch price for this date.');
            }
        },
        error: function() {
            alert('Failed to get package price.');
        }
    });
});


});
</script>
<script>
$(document).ready(function() {
    $('#travel_date').on('change', function() {
        var travelDate = $(this).val();
        var packageId  = <?= $package_data['package_id']; ?>;

        if (!travelDate) return;

        $.ajax({
            url: '<?= base_url('website/get_price_by_date'); ?>',
            type: 'POST',
            dataType: 'json',
            data: {
                type: 'package',
                id: packageId,
                date: travelDate
            },
            success: function(response) {
                var price = response.price ? response.price : 0;
                $('#package_price').html('₹' + price.toLocaleString() + 
                    ' <span class="text-lg font-normal text-slate-500">/ person</span>');
            },
            error: function() {
                alert('Error fetching price. Please try again.');
            }
        });
    });
});
</script>