

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
              <form class="row g-3" id="add-form">
                
                <?php if(get_logged_user_type()!=='agency'): ?>
                <div class="col-md-12">
                  <label class="form-label">Agency</label>
                  <select class="form-select" id="agency_id" name="agency_id" required>
                    <option value="">Select</option>
                    <?php foreach($agencies as $agency){ ?>
                      <option value="<?= $agency['id']; ?>"><?= $agency['name']; ?></option>
                    <?php } ?>
                  </select>
                </div>
                <?php endif; ?>
                <div class="col-md-6">
                  <label class="form-label">Full Name</label>
                  <input type="text" class="form-control" id="fullname" name="fullname" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Email</label>
                  <input type="email" class="form-control" id="email" name="email" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Password</label>
                  <input type="password" class="form-control" id="password" name="password" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Mobile</label>
                  <input type="text" class="form-control" id="mobile" name="mobile" required pattern="\d{10}" maxlength="10" title="Enter a valid 10-digit mobile number">
                </div>

                <div class="col-md-6">
                  <label class="form-label">Date of Birth</label>
                  <input type="date" class="form-control" id="dob" name="dob" required>
                </div>    

                <div class="col-md-6">
                  <label class="form-label">Role</label>
                  <select class="form-select" id="role_id" name="role_id" required>
                    <option value="">Select</option>
                    <?php foreach($roles as $role){ ?>
                      <option value="<?= $role['id']; ?>" data-role-name="<?= $role['role_name']; ?>"><?= $role['role_name']; ?></option>
                    <?php } ?>
                  </select>
                </div>



                <div class="col-12 text-left">
                  <button type="submit" class="btn btn-primary">Save</button>
                  <button type="reset" class="btn btn-danger">Reset</button>
                </div>
              </form>

              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="edit-form">
                  
                  <?php if(get_logged_user_type()!=='agency'): ?>
                  <div class="col-md-12">
                    <label class="form-label">Agency</label>
                    <select class="form-select" id="agency_id" name="agency_id" required>
                      <option value="">Select</option>
                      <?php foreach($agencies as $agency){ ?>
                        <option value="<?= $agency['id']; ?>"><?= $agency['name']; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                  <?php endif; ?>
                  <div class="col-md-12">
                    <label class="form-label">Full Name</label>
                    <input type="text" class="form-control" id="e_fullname" name="fullname" required>
                  </div>

                  <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" id="e_email" name="email" required>
                  </div>


                  <div class="col-md-6">
                    <label class="form-label">Mobile</label>
                    <input type="text" class="form-control" id="e_mobile" name="mobile" required pattern="\d{10}" maxlength="10" title="Enter a valid 10-digit mobile number">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Date of Birth</label>
                    <input type="date" class="form-control" id="e_dob" name="dob" required>
                  </div>    

                  <div class="col-md-6">
                    <label class="form-label">Role</label>
                    <select class="form-select" id="e_role_id" name="role_id" required>
                      <option value="">Select</option>
                      <?php foreach($roles as $role){ ?>
                        <option value="<?= $role['id']; ?>" data-role-name="<?= $role['role_name']; ?>"><?= $role['role_name']; ?></option>
                      <?php } ?>
                    </select>
                  </div>



                    <div class="text-left">
                      <input type="hidden" id="e_id" name="id">
                      <button type="submit" class="btn btn-primary">Save</button>
                      <button type="reset" class="btn btn-danger">Reset</button>
                    </div>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('users/viewUser'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('users/addUser'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('users/viewUser'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('users/editUser'); ?>",
      method: "POST",
      dataType: 'json',
      data: {
          id: id
      },
      success: function(res) {
          $("#e_id").val(res.id);
          $("#e_fullname").val(res.fullname);
          $("#e_email").val(res.email);
          $("#e_mobile").val(res.mobile);
          $("#e_role_id").val(res.role_id);
          $("#e_dob").val(res.dob);
          <?php if (get_logged_user_type() !== 'agency'): ?>
              $("#e_agency_id").val(res.agency_id);
          <?php endif; ?>
      }
  });
}

$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('users/updateUser'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('users/viewUser'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
</script>
