<script>
    $(document).ready(function () {
        $('#roomTable').DataTable({
            "processing": true,      // show processing indicator
            "serverSide": false,     // set to true if you want server-side processing
            "paging": true,
            "searching": true,
            "ordering": true,
            "order": [[0, "asc"]],   // default order by first column
            "lengthMenu": [10, 25, 50, 100],
            "language": {
                "search": "Filter records:",
                "lengthMenu": "Show _MENU_ entries",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "No records available",
                "emptyTable": "No amenities found",
            }
        });
    });
</script>

<!-- Room list table -->
<table class="table table-hover align-middle" id="roomTable">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Property</th>
            <th>Room Name</th>
            <th>Description</th>
            <th>Capacity</th>
            <th>Bed Type</th>
            <th>Size (sqft)</th>
            <th>Status</th>
            <th>Images</th>
            <th>Created</th>
            <th class="text-center">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1;
        foreach ($list as $val) {
            // safe values & description preview
            $property = isset($val['property_name']) ? $val['property_name'] : '';
            $name = isset($val['name']) ? $val['name'] : '';
            $desc = isset($val['description']) ? $val['description'] : '';
            $short = mb_strlen($desc) > 80 ? mb_substr($desc, 0, 80) . '...' : $desc;
            $capacity = isset($val['capacity']) ? (int) $val['capacity'] : '';
            $bed_type = isset($val['bed_type']) ? $val['bed_type'] : '';
            $size = isset($val['size_sqft']) ? $val['size_sqft'] : '';
            $status = isset($val['status']) ? $val['status'] : 'unavailable';
            // created_at fallback
            $created = isset($val['created_at']) ? $val['created_at'] : (isset($val['created']) ? $val['created'] : '');
            ?>
            <tr>
                <td><?= $i++; ?></td>

                <td>
                    <i class="bi bi-building-fill me-1"></i>
                    <?= htmlspecialchars($property); ?>
                </td>

                <td><?= htmlspecialchars($name); ?></td>

                <td>
                    <div data-bs-toggle="tooltip" data-bs-placement="top" title="<?= htmlspecialchars($desc); ?>">
                        <?= htmlspecialchars($short); ?>
                    </div>
                </td>

                <td><?= $capacity; ?></td>

                <td>
                    <span class="badge bg-info text-uppercase"><?= htmlspecialchars($bed_type); ?></span>
                </td>

                <td><?= htmlspecialchars($size); ?></td>

                <td>
                    <?php if ($status === 'available') { ?>
                        <span class="badge bg-success">Available</span>
                    <?php } else { ?>
                        <span class="badge bg-secondary">Unavailable</span>
                    <?php } ?>
                </td>

                <td>
                    <a href="javascript:void(0)" class="btn btn-primary btn-sm edit-btn"
                        onclick="roomImage(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#roomImageModal"
                        data-bs-original-title="Room Image">View</a>
                </td>

                <td>
                    <?= ($created) ? date('d M, Y', strtotime($created)) : '-'; ?>
                </td>

                <td class="text-center">
                    <a href="javascript:void(0)" class="btn btn-sm btn-outline-primary edit-btn"
                        onclick="editData(<?= $val['id']; ?>)" title="Edit">
                        <i class="bi bi-pencil-square"></i>
                    </a>

                    <?php if ($status === 'available') { ?>
                        <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                            onclick="changeStatus(<?= $val['id']; ?>, 'unavailable')" title="Mark Unavailable">
                            <i class="bi bi-x-circle"></i>
                        </a>
                    <?php } else { ?>
                        <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                            onclick="changeStatus(<?= $val['id']; ?>, 'available')" title="Mark Available">
                            <i class="bi bi-check-circle"></i>
                        </a>
                    <?php } ?>
                    <a href="javascript:void(0)" class="btn btn-danger btn-sm"
                        onclick="deleteRecord(<?= $val['id']; ?>, 'rooms')">
                        Delete
                    </a>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>

<!-- JS: DataTables init, tooltips and changeStatus -->
<script>


    function changeStatus(id, newStatus) {
        if (!confirm('Are you sure you want to change status?')) return;

        $.ajax({
            url: "<?= base_url('Dashboard/Status'); ?>",
            method: "POST",
            data: {
                id: id,
                type: newStatus,            // send desired status string 'available' / 'unavailable'
                table: 'rooms',
                column: 'status',
                module: 'room'
            },
            dataType: 'json',
            success: function (res) {
                if (res.return) {
                    // reload listing area
                    $("#tb").load("<?= base_url('room/viewRoom'); ?>");
                    toastr.success(res.msg);
                } else {
                    toastr.error(res.msg);
                }
            },
            error: function () {
                toastr.error('Server error. Try again.');
            }
        });
    }
</script>