<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row">
              <div class="col-sm-6">
                <h4 class="text-dark"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6" style="text-align: right;">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i>
                  Add <?= $title; ?></button>
              </div>
            </div>

          </div>
          <div class="card-body">
            <!-- Table with stripped rows -->
            <div class="table-responsive" id="tb">
            </div>
            <!-- End Table with stripped rows -->

          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->
<!-- Add Modal -->
<div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
  aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form" enctype="multipart/form-data">
          <div class="col-md-6">
            <label class="form-label">Agency Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" class="form-control" id="email" name="email" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Password</label>
            <input type="password" class="form-control" id="password" name="password" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Mobile</label>
            <input type="text" class="form-control" id="mobile" name="mobile" required pattern="\d{10}" maxlength="10"
              title="Enter a valid 10-digit mobile number">
          </div>

          <div class="col-md-6">
            <label class="form-label">Address</label>
            <input type="text" class="form-control" id="address" name="address" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Logo</label>
            <input type="file" class="form-control" id="logo" name="logo" accept="image/*" required>
          </div>

          <!-- <div class="col-md-6">
                  <label class="form-label">Markup Type</label>
                  <select class="form-control" id="markup_type" name="markup_type" required>
                    <option value="">Select</option>
                    <option value="fixed">Fixed</option>
                    <option value="percentage">Percentage</option>
                  </select>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Markup Value</label>
                  <input type="number" step="any" class="form-control" id="markup_value" name="markup_value">
                </div> -->


          <div class="col-12 text-left">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-danger">Reset</button>
          </div>
        </form>



      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
  aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form" enctype="multipart/form-data">
          <div class="col-md-6">
            <label class="form-label">Agency Name</label>
            <input type="text" class="form-control" id="e_name" name="name" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" class="form-control" id="e_email" name="email" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Mobile</label>
            <input type="text" class="form-control" id="e_mobile" name="mobile" required pattern="\d{10}" maxlength="10"
              title="Enter a valid 10-digit mobile number">
          </div>

          <div class="col-md-6">
            <label class="form-label">Address</label>
            <input type="text" class="form-control" id="e_address" name="address" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Logo</label>
            <input type="file" class="form-control" id="e_logo" name="logo" accept="image/*">
          </div>

          <!-- <div class="col-md-6">
                  <label class="form-label">Markup Type</label>
                  <select class="form-control" id="e_markup_type" name="markup_type" required>
                    <option value="">Select</option>
                    <option value="fixed">Fixed</option>
                    <option value="percentage">Percentage</option>
                  </select>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Markup Value</label>
                  <input type="number" step="any" class="form-control" id="e_markup_value" name="markup_value">
                </div> -->


          <div class="col-12 text-left">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-danger">Reset</button>
          </div>
        </form>

      </div>
    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog"
  aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="change-password-form">
          <div class="row g-2">
            <div class="col-md-6">
              <label class="form-label">New Password</label>
              <input class="form-control" id="new_password" name="password" type="password" required="">
            </div>
            <div class="col-md-6">
              <label class="form-label">Confirm Password</label>
              <input class="form-control" id="confirm_password" type="password" required="">
            </div>
            <div class="text-left">
              <input type="hidden" id="agency_id" name="id">
              <button type="submit" class="btn btn-primary">Save</button>
              <button type="reset" class="btn btn-danger">Reset</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script>
  function add() {
    $('#addModal').modal('toggle');
    $('#add-form')[0].reset();
  }
  $(document).ready(function () {
    $("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
    $('#addModal').modal({
      backdrop: 'static',
      keyboard: false
    })
    $('#editModal').modal({
      backdrop: 'static',
      keyboard: false
    })
    $('#tb').load('<?= base_url('agency/viewAgency'); ?>');
  });


  $("#add-form").submit(function (e) {
    e.preventDefault();
    disableButton();
    $.ajax({
      url: "<?php echo base_url('agency/addAgency'); ?>",
      method: "POST",
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function (res) {
        enableButton();
        if (res.return) {
          $('#addModal').modal('toggle');
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('agency/viewAgency'); ?>');
          toastr.success(res.msg);
        }
        else {
          toastr.error(res.msg);
        }

      }
    });
  })

  function editData(id) {
    $.ajax({
      url: "<?= base_url('agency/editAgency'); ?>",
      method: "POST",
      dataType: 'json',
      data: {
        id: id
      },
      success: function (res) {
        $("#e_id").val(res.id);
        $("#e_name").val(res.name);
        $("#e_email").val(res.email);
        $("#e_mobile").val(res.mobile);
        $("#e_address").val(res.address);
        if (res.logo) {
          $("#e_logo").after('<img src="' + res.logo + '" alt="Logo" class="mt-2" width="80">');
        }

        // $("#e_markup_type").val(res.markup_type);
        // $("#e_markup_value").val(res.markup_value);

      }
    });
  }

  $("#edit-form").submit(function (e) {
    e.preventDefault();
    disableButton();
    $.ajax({
      url: "<?php echo base_url('agency/updateAgency'); ?>",
      method: "POST",
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function (res) {
        enableButton();
        if (res.return) {
          $('#editModal').modal('toggle');
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('agency/viewAgency'); ?>');
          toastr.success(res.msg);
        }
        else {
          toastr.error(res.msg);
        }

      }
    });
  })
</script>

<script>
  $('#role_id').change(function () {
    var selectedRole = $(this).find(':selected').data('role-name');

    if (selectedRole === 'student') {
      $('#student-fields').show();
    } else {
      $('#student-fields').hide();
    }
  });
  $('#e_role_id').change(function () {
    var selectedRole = $(this).find(':selected').data('role-name');

    if (selectedRole === 'student') {
      $('#e-student-fields').show();
    } else {
      $('#e-student-fields').hide();
    }
  });

  function changePassword(id) {
    $('#changePasswordModal').modal('toggle');
    $('#agency_id').val(id);
  };
  $("#change-password-form").submit(function (e) {
    e.preventDefault();
    disableButton();
    if ($('#new_password').val() !== $('#confirm_password').val()) {
      enableButton();
      toastr.error("New Password and confirm password does not match");
      return false;
    }
    $.ajax({
      url: "<?php echo base_url('agency/changePassword'); ?>",
      method: "POST",
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function (res) {
        enableButton();
        if (res.return) {
          $('#changePasswordModal').modal('toggle');
          $('#change-password-form')[0].reset();
          $('#tb').load('<?= base_url('agency/viewAgency'); ?>');
          toastr.success(res.msg);
        }
        else {
          toastr.error(res.msg);
        }
      }
    });
  });
</script>