<?php


class Room_model extends CI_Model
{
    public function getRoomRowData($id)
    {
        $this->db
            ->select('t1.*, 
                  t2.name as property_name')
            ->from('rooms t1')
            ->join('properties t2', 't2.id = t1.property_id', 'left')
            ->where('t1.id', $id);


        $query = $this->db->get();




        return $query->row_array();
    }
    public function getRoomResultData()
    {
        $this->db
            ->select('t1.*, 
                  t2.name as property_name')
            ->from('rooms t1')
            ->join('properties t2', 't2.id = t1.property_id', 'left');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function getRoomAmenitiesResultData()
    {
        $this->db
            ->select('t1.*, t2.name as room_name,t3.name as property_name')
            ->from('room_amenities t1')
            ->join('rooms t2', 't2.id = t1.room_id', 'left')
            ->join('properties t3', 't3.id = t2.property_id', 'left');

        $query = $this->db->get();
        return $query->result_array();
    }
    // public function getRoomPricingResultData()
// {
//     $this->db
//         ->select('
//             t1.id,
//             t1.room_id,
//             t1.is_disable,
//             t1.created_at,
//             t2.name as room_name,
//             t3.name as property_name,
//             t4.id as price_date_id,
//             t4.name as price_date_name,
//             t4.from_date,
//             t4.to_date
//         ')
//         ->from('room_pricing t1')
//         ->join('rooms t2', 't2.id = t1.room_id', 'left')
//         ->join('properties t3', 't3.id = t2.property_id', 'left')
//         ->join('price_dates t4', 't4.id = t1.price_date_id', 'left')
//         ->order_by('t2.name, t4.from_date', 'ASC');

    //     $query = $this->db->get();
//     $result = $query->result_array();

    //     // Grouping result by room_id
//     $grouped = [];
//     foreach ($result as $row) {
//         $room_id = $row['room_id'];

    //         if (!isset($grouped[$room_id])) {
//             $grouped[$room_id] = [
//                 'room_id'       => $room_id,
//                 'room_name'     => $row['room_name'],
//                 'property_name' => $row['property_name'],
//                 'is_disable'    => $row['is_disable'],
//                 'created_at'    => $row['created_at'],
//                 'prices'        => [] // will hold multiple date-price records
//             ];
//         }

    //         $grouped[$room_id]['prices'][] = [
//             'price_date_name' => $row['price_date_name'],
//             'from_date'       => $row['from_date'],
//             'to_date'         => $row['to_date'],
//             'price'           => $row['price'],
//         ];
//     }

    //     return array_values($grouped); // reset numeric keys for foreach in view
// }
    public function getRoomPricingResultData($where = null, $search = null)
    {
        $this->db
            ->select('
            t1.room_id,
            t1.price_date_id,
            t1.meal_plan,
            t1.room_rate,
            t1.eb_adult,
            t1.eb_child,
            t1.cnb,
            t1.is_disable,
            t1.created_at,

            t2.name as room_name,
            t3.name as property_name,

            t4.name as price_date_name,
            t4.from_date,
            t4.to_date,
            t5.name as country_name,
            t6.name as state_name,
            t7.name as city_name
        ')
            ->from('room_pricing t1')
            ->join('rooms t2', 't2.id = t1.room_id', 'left')
            ->join('properties t3', 't3.id = t2.property_id', 'left')
            ->join('price_dates t4', 't4.id = t1.price_date_id', 'left')
            ->join('countries t5', 't5.id = t3.country', 'left')
            ->join('states t6', 't6.id = t3.state', 'left')
            ->join('cities t7', 't7.id = t3.city', 'left');
        // ->order_by('t2.name, t4.from_date', 'ASC');


        if (isset($where) && $where !== null) {
            foreach ($where as $key => $val) {
                $this->db->where($key, $val);
            }
        }
        if (!empty($search)) {
            $this->db->group_start()
                ->like('t2.name', $search)
                ->or_like('t3.name', $search)
                ->group_end();
        }


        $rows = $this->db->get()->result_array();



        $grouped = [];

        foreach ($rows as $row) {

            $room = $row['room_id'];
            $date = $row['price_date_id'];
            $plan = $row['meal_plan'];

            // Room level
            if (!isset($grouped[$room])) {
                $grouped[$room] = [
                    'room_id' => $room,
                    'room_name' => $row['room_name'],
                    'state_name' => $row['state_name'],
                    'city_name' => $row['city_name'],
                    'property_name' => $row['property_name'],
                    'is_disable' => $row['is_disable'],
                    'created_at' => $row['created_at'],
                    'dates' => []
                ];
            }

            // Date level
            if (!isset($grouped[$room]['dates'][$date])) {
                $grouped[$room]['dates'][$date] = [
                    'price_date_name' => $row['price_date_name'],
                    'from_date' => $row['from_date'],
                    'to_date' => $row['to_date'],
                    'plans' => []
                ];
            }

            // Meal plan level
            $grouped[$room]['dates'][$date]['plans'][$plan] = [
                'room_rate' => $row['room_rate'],
                'eb_adult' => $row['eb_adult'],
                'eb_child' => $row['eb_child'],
                'cnb' => $row['cnb'],
            ];
        }

        return array_values($grouped);
    }

    public function roomImage($room_id)
    {
        $images = $this->db->get_where('room_image', ['room_id' => $room_id])->result_array();
        $data = '';
        $i = 1;
        foreach ($images as $image) {
            $ext = substr($image['image'], strrpos($image['image'], '.') + 1);
            $data .= '<tr>';
            $data .= '<td>' . $i++ . '</td>';

            if ($ext == 'mp4' || $ext == 'mov') {
                $data .= '<td><iframe src="' . base_url('assets/uploads/' . $image['image']) . '" height="80" width="100"></iframe></td>';
            } else {
                $data .= '<td><img src="' . base_url('assets/uploads/' . $image['image']) . '" height="70"></td>';
            }

            $data .= '<td>';
            if ($image['is_cover'] !== '1') {
                $data .= '<button class="btn btn-sm btn-danger" onclick="deleteRoomImage(' . $image['id'] . ',' . $room_id . ')">Delete</button>';
            } else {
                $data .= '<button class="btn btn-sm btn-danger" onclick="roomDeleteAlert()">Delete</button>';
            }
            if ($image['is_cover'] !== '1') {
                $data .= '<button class="btn btn-sm btn-primary" onclick="makeRoomCoverImage(' . $image['id'] . ',' . $room_id . ')">Make cover</button>';
            }
            $data .= '</td>';
            $data .= '</tr>';
        }
        echo $data;
    }
    public function addRoomImage($room_id)
    {
        $data = array();
        if (!empty($_FILES['room_image']['name'])) {
            $config['file_name'] = rand(10000, 10000000000);
            $config['upload_path'] = './assets/uploads/room';
            $config['allowed_types'] = 'jpg|jpeg|png|mp4|mov';
            $this->load->library('upload', $config);
            $this->upload->initialize($config);

            //upload images
            $_FILES['room_images']['name'] = $_FILES['room_image']['name'];
            $_FILES['room_images']['type'] = $_FILES['room_image']['type'];
            $_FILES['room_images']['tmp_name'] = $_FILES['room_image']['tmp_name'];
            $_FILES['room_images']['size'] = $_FILES['room_image']['size'];
            $_FILES['room_images']['error'] = $_FILES['room_image']['error'];

            if ($this->upload->do_upload('room_images')) {
                $image_data = $this->upload->data();

                $config2 = array(
                    'image_library' => 'gd2', //get original image
                    'source_image' => './assets/uploads/room/' . $image_data['file_name'],
                    'width' => 540,
                    'height' => 600,
                    'maintain_ratio' => FALSE,
                    'new_image' => './assets/uploads/room/' . $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();

                $fileName = "room/" . $image_data['file_name'];
                $data['image'] = $fileName;
                $data['room_id'] = $room_id;
            }
        } else {
            $data['image'] = '';
            $data['room_id'] = '';
        }
        return $this->db->insert('room_image', $data);

    }
    public function deleteRoomImage($id)
    {
        $image = $this->model->getRowData('room_image', ['id' => $id]);
        $prod_image = ltrim($image['image'], '/');
        if (is_file(base_url('assets/uploads/' . $prod_image))) {
            unlink(base_url('assets/uploads/' . $prod_image));
        }
        return $this->db->delete('room_image', ['id' => $id]);

    }


}

?>