<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room_amenities extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
        $this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title'] = 'Room Amenities';
        $data['properties'] = $this->model->getResultData('properties', []); 
        $data['rooms']      = $this->model->getResultData('rooms', []);
        $page = 'room_amenities/index';
        $this->header_and_footer($page, $data);
    }

    public function addAmenity()
    {
        $countData = $this->model->countData('room_amenities', [
            'property_id'  => $_POST['property_id'],
            'room_id'      => $_POST['room_id'],
            'amenity_name' => $_POST['amenity_name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Amenity already exists for this room']);
            return;
        }

        $array = [
            'property_id'  => $_POST['property_id'],
            'room_id'      => $_POST['room_id'],
            'amenity_name' => $_POST['amenity_name'],
        ];

        if ($this->model->add('room_amenities', $array)) {
            $amenity_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $amenity_id,
                'add',
                'Room Amenity'
            );

            echo json_encode(['return' => true, 'msg' => 'Amenity Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add amenity']);
        }
    }

    public function viewAmenities()
    {
        $data['list'] = $this->room_model->getRoomAmenitiesResultData(); 
        $this->load->view('room_amenities/tb', $data);
    }

    public function editAmenity()
    {
        $data = $this->model->getRowData('room_amenities',['id'=>$_POST['id']]);

        $response = [
            'id'           => $_POST['id'],
            'property_id'  => $data['property_id'],
            'room_id'      => $data['room_id'],
            'amenity_name' => $data['amenity_name'],
        ];

        echo json_encode($response);
    }

    public function updateAmenity()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'property_id'  => $_POST['property_id'],
            'room_id'      => $_POST['room_id'],
            'amenity_name' => $_POST['amenity_name'],
        ];

        if ($this->model->edit('room_amenities', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Room Amenity'
            );

            echo json_encode(['return' => true, 'msg' => 'Amenity Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    public function getRoomsByProperty()
    {
        $property_id = $this->input->post('property_id');
        $rooms = $this->model->getResultData('rooms', ['property_id' => $property_id]);

        $options = '<option value="">Select Room</option>';
        foreach($rooms as $room){
            $options .= '<option value="'.$room['id'].'">'.$room['name'].'</option>';
        }
        echo $options;
    }

}
