<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Property extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title'] = 'Properties';
        $data['countries'] = $this->model->getResultData('countries', []);

        // Fetch destinations for dropdown
        $rows = $this->property_model->getPropertyResultData();

        $states = [];
        foreach ($rows as $row) {
            if ($row['state']) {
                $states[$row['state']] = [
                    'id' => $row['state'],
                    'name' => $row['state_name']
                ];
            }
        }

        $data['destinations'] = array_values($states);

        $page = 'property/index';
        $this->header_and_footer($page, $data);
    }

    public function addProperty()
    {
        $countData = $this->model->countData('properties', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Property already exists']);
            return;
        }

        $logo_path = null;
        if (!empty($_FILES['logo']['name'])) {
            $logo = upload_file('logo', 'property_logo', true, 400, 300, true);
            if ($logo['status']) {
                $logo_path = $logo['file_path'];
            }
        }

        // Prepare property data
        $array = [
            'name' => $_POST['name'],
            'type' => $_POST['type'],
            'address' => $_POST['address'],
            'city' => $_POST['city'],
            'state' => $_POST['state'],
            'country' => $_POST['country'],
            'google_map_link' => $_POST['google_map_link'],
            'description' => $_POST['description'],
            'logo' => $logo_path,
        ];

        if ($this->model->add('properties', $array)) {
            $prop_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $prop_id,
                'add',
                'Property'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add property']);
        }
    }


    public function viewProperty()
    {
        $where = [];

        $destination_id = $this->input->post('destination_id');
        $city_id = $this->input->post('city_id');
        $search = $this->input->post('search');

        if (!empty($destination_id)) {
            $where['t3.id'] = $destination_id;
        }

        if (!empty($city_id)) {
            $where['t4.id'] = $city_id;
        }


        $data['list'] = $this->property_model->getPropertyResultData($where, $search);
        $this->load->view('property/tb', $data);
    }

    public function editProperty()
    {
        $data = $this->model->getRowData('properties', ['id' => $_POST['id']]);

        $response = [
            'id' => $_POST['id'],
            'name' => $data['name'],
            'type' => $data['type'],
            'address' => $data['address'],
            'city' => $data['city'],
            'state' => $data['state'],
            'country' => $data['country'],
            'google_map_link' => $data['google_map_link'],
            'description' => $data['description'],
            'logo' => base_url('assets/uploads/' . $data['logo'] . ''),
        ];

        echo json_encode($response);
    }

    public function updateProperty()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'name' => $_POST['name'],
            'type' => $_POST['type'],
            'address' => $_POST['address'],
            'city' => $_POST['city'],
            'state' => $_POST['state'],
            'country' => $_POST['country'],
            'google_map_link' => $_POST['google_map_link'],
            'description' => $_POST['description'],
        ];

        if (!empty($_FILES['logo']['name'])) {
            $logo = upload_file('logo', 'property_logo', true, 400, 300, true);

            if ($logo['status']) {
                $new_logo = $logo['file_path'];

                // Delete old logo
                $oldData = $this->model->getRowData('properties', ['id' => $id]);
                if (!empty($oldData['logo'])) {
                    $old_logo_path = FCPATH . 'assets/uploads/' . $oldData['logo'];
                    if (file_exists($old_logo_path)) {
                        unlink($old_logo_path);
                    }
                }

                $array['logo'] = $new_logo;
            }
        }

        if ($this->model->edit('properties', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Property'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    //Property Amenities

    public function property_amenities()
    {
        $data['title'] = 'Property Amenities';
        $data['properties'] = $this->model->getResultData('properties', ['is_disable' => 0]);
        $page = 'property_amenities/index';
        $this->header_and_footer($page, $data);
    }

    public function viewPropertyAmenities()
    {
        $data['list'] = $this->property_model->getPropertyAmenitiesResultData();
        $this->load->view('property_amenities/tb', $data);
    }

    public function addPropertyAmenities()
    {
        $countData = $this->model->countData('property_amenities', [
            'amenity_name' => $_POST['amenity_name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'amenity already exists']);
            return;
        }

        $array = [
            'property_id' => $_POST['property_id'],
            'amenity_name' => $_POST['amenity_name'],
        ];

        if ($this->model->add('property_amenities', $array)) {
            $prop_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $prop_id,
                'add',
                'Property amenities'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add property']);
        }
    }

    public function editPropertyAmenities()
    {
        $data = $this->model->getRowData('property_amenities', ['id' => $_POST['id']]);

        $response = [
            'id' => $_POST['id'],
            'property_id' => $data['property_id'],
            'amenity_name' => $data['amenity_name'],
        ];

        echo json_encode($response);
    }

    public function updatePropertyAmenities()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'property_id' => $_POST['property_id'],
            'amenity_name' => $_POST['amenity_name'],
        ];


        if ($this->model->edit('property_amenities', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Property amenities'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    public function propertyImages()
    {
        $data['title'] = 'Property Images';
        $page = 'property/images';
        $this->header_and_footer($page, $data);
    }

    public function property_policies()
    {
        $data['title'] = 'Property Policies';
        $data['properties'] = $this->model->getResultData('properties', ['is_disable' => 0]);
        $page = 'property_policies/index';
        $this->header_and_footer($page, $data);
    }
    public function viewPropertyPolicies()
    {
        $data['list'] = $this->property_model->getPropertyPoliciesResultData();
        $this->load->view('property_policies/tb', $data);
    }

    public function addPropertyPolicies()
    {

        $array = [
            'property_id' => $_POST['property_id'],
            'policy_type' => $_POST['policy_type'],
            'policy_text' => $_POST['policy_text'],
        ];

        if ($this->model->add('property_policies', $array)) {
            $prop_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $prop_id,
                'add',
                'Property policies'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add property']);
        }
    }

    public function editPropertyPolicies()
    {
        $data = $this->model->getRowData('property_policies', ['id' => $_POST['id']]);

        $response = [
            'id' => $_POST['id'],
            'property_id' => $data['property_id'],
            'policy_type' => $data['policy_type'],
            'policy_text' => $data['policy_text'],
        ];

        echo json_encode($response);
    }

    public function updatePropertyPolicies()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'property_id' => $_POST['property_id'],
            'policy_type' => $_POST['policy_type'],
            'policy_text' => $_POST['policy_text'],
        ];


        if ($this->model->edit('property_policies', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Property policies'
            );

            echo json_encode(['return' => true, 'msg' => 'Property Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    public function propertyReviews()
    {
        $data['title'] = 'Property Reviews';
        $page = 'property/reviews';
        $this->header_and_footer($page, $data);
    }
}
