<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$host = $_SERVER['HTTP_HOST'];
$parts = explode('.', $host);

// // if localhost, adjust (localhost/project/… won’t have real subdomains)
// if ($parts[0] !== 'localhost' && $parts[0] !== 'www') {
//     $subdomain = $parts[0];
    
//     // Load agency routes
//     $route['default_controller'] = "Agency_auth";
// } else {
//     $route['default_controller'] = "Auth";
// }
$route['default_controller'] = "web_auth/agent_login";
$route['agent-logout'] = 'web_auth/agent_logout';

$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['admin'] = 'Auth';
$route['agency-login'] = 'Agency_auth';
$route['dashboard'] = 'Dashboard';
$route['change-password'] = 'Auth/change_pass/';
$route['logout'] = 'Dashboard/logout';






//Roles
$route['roles'] = 'Roles';

//Agents
$route['agents'] = 'Agent';

//Inquiry
$route['inquiries'] = 'Inquiry';

//Package Inquiry
$route['package-inquiries'] = 'Package_inquiry';

//Custom Inquiry
$route['custom-inquiries'] = 'Custom_inquiry';

//Agency
$route['agency'] = 'Agency';

//Price Dates
$route['price-dates'] = 'Price_dates';

//Permissions
$route['permission'] = 'Permission';

//Assign Permissions
$route['assign-permission'] = 'Assign_permission';


//Property
$route['properties']         = 'Property';
$route['property-images']    = 'Property/property_images';
$route['property-amenities'] = 'Property/property_amenities';
$route['property-policies']  = 'Property/property_policies';
$route['property-reviews']   = 'Property/property_reviews';

// 🔹 Room Controller
$route['rooms']             = 'Room';
$route['room-amenities']    = 'Room_amenities';
$route['room-pricing']      = 'Room_pricing';

// 🔹 Booking Controller
$route['bookings'] = 'Bookings';



// Packages Module Routes
$route['packages'] = 'packages/index';                 // All Packages
$route['package-pricing']      = 'Package_pricing';

     

$route['package-images'] = 'package_images/index';                
$route['package-images/add'] = 'package_images/add';              
$route['package-images/edit/(:num)'] = 'package_images/edit/$1';  
$route['package-images/delete/(:num)'] = 'package_images/delete/$1'; 

$route['destinations'] = 'destination';                
$route['themes'] = 'theme';                
$route['manage-packages'] = 'package';    
$route['package-inclusions'] = 'package_inclusions';                       









// WEBSITE
$route['agent-dashboard']  = 'website';
$route['packages']  = 'website/packages';
$route['custom-packages']  = 'website/custom_packages';
$route['package-details/(:num)']  = 'website/package_details/$1';
$route['hotels']    = 'website/hotels';
$route['reports']   = 'website/reports';
$route['hotel-details/(:num)']  = 'website/hotel_details/$1';
$route['agency-inquiries'] = 'website/inquiries';
$route['agent-profile']  = 'website/agent_profile';
$route['inquiry-pdf/(:num)']  = 'website/inquiry_pdf';




$route['destination/fetch_cities'] = 'destination/fetch_cities';
$route['destination/get_linked_cities'] = 'destination/get_linked_cities';
$route['destination/save_cities'] = 'destination/save_cities';
$route['destination/delete_city_link'] = 'destination/delete_city_link';
