<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Packages extends CI_Controller {
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
    }

    // Header & Footer loader
    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page, $data);
        $this->load->view('includes/footer');
    }

    // Package List Page
    public function index()
    {
        $data['title'] = 'Packages';
        $data['packages'] = $this->package->get_all_packages();
        $this->header_and_footer('packages/index', $data);
    }

	public function viewPackages()
    {
        // $data['list'] = $this->package_model->get_all_packages(); 
        $this->load->view('packages/tb', $data);
    }

    // Add Package
    public function add()
    {
        // Validate duplicate code
        $countData = $this->package->check_duplicate('package_code', $_POST['package_code']);
        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Package code already exists']);
            return;
        }

        // Insert package
        $package_id = $this->package->insert_package($_POST);

        // Insert themes and inclusions mapping
        if ($package_id) {
            if (!empty($_POST['themes'])) {
                $this->package->insert_package_themes($package_id, $_POST['themes']);
            }
            if (!empty($_POST['inclusions'])) {
                $this->package->insert_package_inclusions($package_id, $_POST['inclusions']);
            }

            echo json_encode(['return' => true, 'msg' => 'Package added successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add package']);
        }
    }

    // Edit Package - get data for form
    public function edit($id)
    {
        $package = $this->package->get_package($id);
        if ($package) {
            echo json_encode($package);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Package not found']);
        }
    }

    // Update Package
    public function update($id)
    {
        // Check duplicate code
        $countData = $this->package->check_duplicate('package_code', $_POST['package_code'], $id);
        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Package code already exists']);
            return;
        }

        // Update package
        $this->package->update_package($id, $_POST);

        // Update themes and inclusions mapping
        $this->package->update_package_themes($id, $_POST['themes'] ?? []);
        $this->package->update_package_inclusions($id, $_POST['inclusions'] ?? []);

        echo json_encode(['return' => true, 'msg' => 'Package updated successfully']);
    }

    // Delete Package (Soft Delete)
    public function delete($id)
    {
        $this->package->delete_package($id);
        echo json_encode(['return' => true, 'msg' => 'Package deleted successfully']);
    }
}
