<div class="space-y-6">
    <?php if(!empty($hotels)): ?>
        <?php foreach($hotels as $hotel): ?>
            <div class="bg-white rounded-lg shadow-md border border-slate-200 flex flex-col md:flex-row overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="md:w-1/3">
                    <img src="<?= base_url($hotel['logo']); ?>" alt="<?= $hotel['name']; ?>" class="w-full h-full object-cover">
                </div>
                <div class="p-6 flex flex-col justify-between md:w-2/3">
                    <div>
                        <div class="flex justify-between items-start">
                            <div>
                                <h3 class="text-2xl font-bold text-slate-800"><?= $hotel['name']; ?></h3>
                                <p class="text-sm text-slate-500 mb-2"><?= $hotel['address']; ?>, <?= $hotel['city']; ?></p>
                            </div>
                            <div class="flex flex-col items-end">
                                <div class="bg-sky-600 text-white font-bold text-lg rounded-md px-3 py-1"><?= $hotel['rating'] ?? rand(7,10); ?></div>
                                <p class="text-xs text-slate-500"><?= rand(200,5000); ?> reviews</p>
                            </div>
                        </div>
                        <div class="flex items-center my-2">
                            <span class="text-yellow-400">
                                <?= str_repeat("★", $hotel['star_rating'] ?? 4); ?>
                                <?= str_repeat("☆", 5 - ($hotel['star_rating'] ?? 4)); ?>
                            </span>
                            <span class="text-xs text-slate-500 ml-2"><?= $hotel['star_rating'] ?? 4; ?>-star hotel</span>
                        </div>
                        <p class="text-sm text-slate-600 mb-4"><?= $hotel['description']; ?></p>
                    </div>
                    <div class="border-t pt-4 mt-4 flex flex-col sm:flex-row justify-between items-center">
                        <div>
                            <p class="text-sm text-slate-500">Price per night</p>
                            <p class="text-2xl font-bold text-orange-600">₹<?= number_format($hotel['price'] ?? rand(2000,10000)); ?></p>
                        </div>
                        <a href="#" class="w-full sm:w-auto mt-4 sm:mt-0 bg-orange-500 hover:bg-orange-600 text-white font-bold py-3 px-6 rounded-md transition-colors text-center">View Rooms</a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No hotels found.</p>
    <?php endif; ?>
</div>
