<main class="flex-grow">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <div class="mb-8">
            <h1 class="text-4xl font-bold text-slate-800">Edit Profile</h1>
        </div>

        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Sidebar -->
            <aside class="w-full lg:w-1/3 xl:w-1/4">
                <!-- Profile Picture -->
                <div class="bg-white p-6 rounded-lg shadow-md border text-center">
                    <img id="profile-pic" class="h-32 w-32 rounded-full object-cover mx-auto ring-4 ring-slate-100"
                        src="<?= !empty($agent['profile_pic']) ? base_url('assets/uploads/' . $agent['profile_pic']) : 'https://placehold.co/200x200/a3e635/44403c?text=' . strtoupper(substr($agent['fullname'], 0, 2)) ?>"
                        alt="Profile Picture">
                    <label for="photo-upload"
                        class="mt-4 inline-block text-sm font-medium text-sky-600 cursor-pointer hover:text-sky-800">Choose
                        Photo</label>
                    <input type="file" id="photo-upload" class="hidden">
                </div>

                <!-- Company Logo -->
                <div class="bg-white p-6 rounded-lg shadow-md border text-center mt-8">
                    <img id="company-logo" class="h-20 w-auto object-contain mx-auto"
                        src="<?= !empty($agent['company_logo']) ? base_url('assets/uploads/' . $agent['company_logo']) : 'https://placehold.co/300x100/e0f2fe/0c4a6e?text=' . $agent['agency_name'] ?>"
                        alt="Company Logo">
                    <label for="logo-upload"
                        class="mt-4 inline-block text-sm font-medium text-sky-600 cursor-pointer hover:text-sky-800">Choose
                        Company Logo</label>
                    <input type="file" id="logo-upload" class="hidden">
                    <!-- <p class="text-xs text-slate-400 mt-1">JPG or PNG. Recommended: 300x100 px.</p> -->
                </div>
            </aside>

            <!-- Form -->
            <div class="w-full lg:w-2/3 xl:w-3/4">
                <form id="profileForm" class="bg-white rounded-lg shadow-md border border-slate-200">
                    <input type="hidden" name="id" value="<?= $agent['id'] ?>">
                    <input type="hidden" name="agency_id" value="<?= $agent['agency_id'] ?>">

                    <div class="p-6">
                        <h3 class="text-xl font-bold text-slate-800 border-b pb-4">Profile Information</h3>
                        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-slate-600">Full Name</label>
                                <input type="text" name="fullname" value="<?= $agent['fullname'] ?>"
                                    class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-slate-600">Email</label>
                                <input type="email" name="email" value="<?= $agent['email'] ?>"
                                    class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm"
                                    readonly>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-slate-600">Phone</label>
                                <input type="text" name="mobile" value="<?= $agent['mobile'] ?>"
                                    class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-slate-600">Date of Birth</label>
                                <input type="date" name="dob" value="<?= $agent['dob'] ?>"
                                    class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                            </div>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-4">

                                <!-- Markup Type -->
                                <div>
                                    <label class="block text-sm font-medium text-slate-600">Markup Type</label>
                                    <select name="markup_type"
                                        class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                                        <option value="">Select Type</option>
                                        <option value="percentage" <?= ($agent['markup_type'] == 'percentage') ? 'selected' : '' ?>>
                                            Percentage (%)
                                        </option>
                                        <option value="fixed" <?= ($agent['markup_type'] == 'fixed') ? 'selected' : '' ?>>
                                            Flat Value (₹)
                                        </option>
                                    </select>
                                </div>

                                <!-- Markup Value -->
                                <div>
                                    <label class="block text-sm font-medium text-slate-600">Markup Value</label>
                                    <input type="number" step="0.01" name="markup_value"
                                        value="<?= $agent['markup_value'] ?>" placeholder="Enter value"
                                        class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:ring-sky-500 focus:border-sky-500 sm:text-sm">
                                </div>


                            </div>

                        </div>
                    </div>


                    <div class="p-6 border-t bg-slate-50 flex justify-end gap-4 rounded-b-lg">
                        <button type="reset"
                            class="border border-slate-300 bg-white text-slate-700 font-bold py-2 px-4 rounded-md hover:bg-slate-50">Cancel</button>
                        <button type="submit"
                            class="bg-sky-600 text-white font-bold py-2 px-4 rounded-md hover:bg-sky-700">Save
                            Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>


<script>
    $(document).ready(function () {
        // Profile form update
        $('#profileForm').on('submit', function (e) {
            e.preventDefault();
            $.ajax({
                url: "<?= base_url('website/update_profile') ?>",
                method: "POST",
                data: $(this).serialize(),
                dataType: "json",
                success: function (res) {
                    if (res.status) {
                        alert(res.message);
                    } else {
                        alert("Error: " + res.error);
                    }
                }
            });
        });

        // Upload company logo
        $('#logo-upload').on('change', function () {
            let formData = new FormData();
            formData.append('company_logo', this.files[0]);
            formData.append('agency_id', $('input[name=agency_id]').val());

            $.ajax({
                url: "<?= base_url('website/upload_logo') ?>",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                dataType: "json",
                success: function (res) {
                    if (res.status) {
                        $('#company-logo').attr('src', res.file);
                    } else {
                        alert(res.error);
                    }
                }
            });
        });
    });
    // Upload profile picture
    $('#photo-upload').on('change', function () {
        let formData = new FormData();
        formData.append('profile_pic', this.files[0]);

        $.ajax({
            url: "<?= base_url('website/upload_profile_pic') ?>",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: "json",
            success: function (res) {
                if (res.status) {
                    $('#profile-pic').attr('src', res.file);
                } else {
                    alert(res.error);
                }
            }
        });
    });

</script>