<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <div class="col-md-12">
            <label for="name">Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>

      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <div class="col-md-12">
            <label for="name">Name</label>
            <input type="text" class="form-control" id="e_name" name="name" required>
          </div>

          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('theme/viewTheme'); ?>');
});

// Add Theme
$("#add-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('theme/addTheme'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#addModal').modal('hide');
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('theme/viewTheme'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Edit Theme
function editData(id) {
  $.ajax({
    url: "<?= base_url('theme/editTheme'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_id").val(res.id);
      $("#e_name").val(res.name);
      $("#e_description").val(res.description);
      $('#editModal').modal('show');
    }
  });
}

// Update Theme
$("#edit-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('theme/updateTheme'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#editModal').modal('hide');
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('theme/viewTheme'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

</script>
