<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room_pricing_options extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    /*--------------------------------------------
     | INDEX PAGE
     --------------------------------------------*/
    public function index()
    {
        $data['title'] = 'Room Pricing Options';
        $page = 'room_pricing_options/index';
        $this->header_and_footer($page, $data);
    }

    /*--------------------------------------------
     | ADD ROOM PRICING OPTION
     --------------------------------------------*/
    public function addRoomPricingOption()
    {
        $countData = $this->model->countData('room_pricing_options', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Option with this name already exists']);
            return;
        }

        $array = [
            'name'    => $_POST['name'],
            'remarks' => $_POST['remarks'] ?? null,
        ];

        if ($this->model->add('room_pricing_options', $array)) {

            $id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'add',
                'Room Pricing Option'
            );

            echo json_encode(['return' => true, 'msg' => 'Room Pricing Option Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add option']);
        }
    }

    /*--------------------------------------------
     | VIEW LIST
     --------------------------------------------*/
    public function viewRoomPricingOptions()
    {
        $data['list'] = $this->model->getResultData('room_pricing_options', []);
        $this->load->view('room_pricing_options/tb', $data);
    }

    /*--------------------------------------------
     | EDIT
     --------------------------------------------*/
    public function editRoomPricingOption()
    {
        $data = $this->model->getRowData('room_pricing_options', ['id' => $_POST['id']]);

        $response = [
            'id'      => $data['id'],
            'name'    => $data['name'],
            'remarks' => $data['remarks'],
        ];

        echo json_encode($response);
    }

    /*--------------------------------------------
     | UPDATE
     --------------------------------------------*/
    public function updateRoomPricingOption()
    {
        if (empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'name'    => $_POST['name'],
            'remarks' => $_POST['remarks'] ?? null,
        ];

        if ($this->model->edit('room_pricing_options', $array, ['id' => $id])) {

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Room Pricing Option'
            );

            echo json_encode(['return' => true, 'msg' => 'Room Pricing Option Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

}
