<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title'] = 'Rooms';
        $data['properties'] = $this->model->getResultData('properties', []); // to select property while adding room
        $page = 'room/index';
        $this->header_and_footer($page, $data);
    }

    public function addRoom()
    {
        $countData = $this->model->countData('rooms', [
            'name' => $_POST['name'],
            'property_id' => $_POST['property_id']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Room already exists for this property']);
            return;
        }

        $array = [
            'property_id' => $_POST['property_id'],
            'name' => $_POST['name'],
            'description' => $_POST['description'],
            'capacity' => $_POST['capacity'],
            'bed_type' => $_POST['bed_type'],
            'size_sqft' => $_POST['size_sqft'],
            'status' => $_POST['status'],
        ];

        if ($this->model->add('rooms', $array)) {
            $room_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $room_id,
                'add',
                'Room'
            );

            echo json_encode(['return' => true, 'msg' => 'Room Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add room']);
        }
    }

    public function viewRoom()
    {
        $data['list'] = $this->room_model->getRoomResultData('rooms', []);
        $this->load->view('room/tb', $data);
    }

    public function editRoom()
    {
        $data = $this->model->getRowData('rooms', ['id' => $_POST['id']]);

        $response = [
            'id' => $_POST['id'],
            'property_id' => $data['property_id'],
            'name' => $data['name'],
            'description' => $data['description'],
            'capacity' => $data['capacity'],
            'bed_type' => $data['bed_type'],
            'size_sqft' => $data['size_sqft'],
            'status' => $data['status'],
        ];

        echo json_encode($response);
    }

    public function updateRoom()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'property_id' => $_POST['property_id'],
            'name' => $_POST['name'],
            'description' => $_POST['description'],
            'capacity' => $_POST['capacity'],
            'bed_type' => $_POST['bed_type'],
            'size_sqft' => $_POST['size_sqft'],
            'status' => $_POST['status'],
        ];

        if ($this->model->edit('rooms', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Room'
            );

            echo json_encode(['return' => true, 'msg' => 'Room Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    public function roomImage()
    {
        $data['list'] = $this->room_model->roomImage($_POST['room_id']);
    }
    public function deleteRoomImage()
    {
        if (isset($_POST['image_id'])) {
            if ($this->room_model->deleteRoomImage($_POST['image_id'])) {
                $lead_id = $_POST['image_id'];
                $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'edit', 'room image');
                echo json_encode(['return' => true, 'msg' => 'Image Deleted Successfully']);
            }
        }
    }
    public function addRoomImage()
    {
        if ($_POST['room_id']) {
            if ($this->room_model->addRoomImage($_POST['room_id'])) {
                $lead_id = $this->db->insert_id();
                $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'add', 'room image');
                echo json_encode(['return' => true, 'msg' => 'Added Successfully']);
            }
        }
    }
    public function makeRoomCoverImage()
    {
        if (isset($_POST['image_id'])) {
            if ($this->model->edit('room_image', ['is_cover' => 0], ['room_id' => $_POST['room_id']])) {
                $this->model->edit('room_image', ['is_cover' => 1], ['id' => $_POST['image_id']]);

                echo json_encode(['return' => true, 'msg' => 'Cover Updated Successfully']);
            }
        }
    }
}
