<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package_inclusions extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    // =========================================
    // INDEX PAGE
    // =========================================
    public function index()
    {
        $data['title'] = 'Package Inclusions';
        $data['packages'] = $this->model->getResultData('packages', ['is_disable'=>0]);
        $page = 'package_inclusions/index';
        $this->header_and_footer($page, $data);
    }

    // =========================================
    // ADD INCLUSION
    // =========================================
    public function addInclusion()
    {
        if (empty($_POST['package_id']) || empty($_POST['inclusion_text'])) {
            echo json_encode(['return' => false, 'msg' => 'All fields are required']);
            return;
        }

        $array = [
            'package_id'     => $_POST['package_id'],
            'inclusion_text' => trim($_POST['inclusion_text'])
        ];

        if ($this->model->add('package_inclusions', $array)) {
            $inclusion_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $inclusion_id,
                'add',
                'Package Inclusion'
            );

            echo json_encode(['return' => true, 'msg' => 'Inclusion Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add inclusion']);
        }
    }

    // =========================================
    // VIEW INCLUSIONS (TABLE LIST)
    // =========================================
    public function viewInclusion()
    {
        $this->db->select('i.*, p.title as package_title');
        $this->db->from('package_inclusions i');
        $this->db->join('packages p', 'p.id = i.package_id', 'left');
        $query = $this->db->get();
        $data['list'] = $query->result_array();

        $this->load->view('package_inclusions/tb', $data);
    }

    // =========================================
    // EDIT INCLUSION (FETCH DATA)
    // =========================================
    public function editInclusion()
    {
        $data = $this->model->getRowData('package_inclusions', ['id' => $_POST['id']]);

        $response = [
            'id'             => $data['id'],
            'package_id'     => $data['package_id'],
            'inclusion_text' => $data['inclusion_text']
        ];

        echo json_encode($response);
    }

    // =========================================
    // UPDATE INCLUSION
    // =========================================
    public function updateInclusion()
    {
        if (empty($_POST['id']) || empty($_POST['package_id']) || empty($_POST['inclusion_text'])) {
            echo json_encode(['return' => false, 'msg' => 'All fields are required']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'package_id'     => $_POST['package_id'],
            'inclusion_text' => trim($_POST['inclusion_text'])
        ];

        if ($this->model->edit('package_inclusions', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Package Inclusion'
            );

            echo json_encode(['return' => true, 'msg' => 'Inclusion Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }
}
