<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('role') != 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

	public function logs()
    {
        $data['title'] = 'Logs';
        $page = 'logs/index';
        $this->header_and_footer($page, $data);
    }
	public function viewLogs()
    {
		$data['list'] = $this->model->getResultData('logs',[],null,'id','desc');
		$this->load->view('logs/tb',$data);
    }
	public function deleteLogs()
    {
        if($_POST['id'])
		{
			if($this->model->deleteData('logs',['id' => $_POST['id']]))
			{
				$this->viewLogs();
			}
			
		}
    }
	}
