<!-- Main Content -->
<main class="flex-grow">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-4xl font-bold text-slate-800">Holiday Packages</h1>
            <p class="text-slate-500 mt-2">Find the perfect curated trip for your clients.</p>
        </div>

        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Left Sidebar: Filters -->
            <aside class="w-full lg:w-1/4">
                <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200 sticky top-24">
                    <h3 class="text-lg font-bold mb-4">Filter Packages</h3>
                    <div class="space-y-6">

                        <form method="POST" action="<?= base_url('website/packages'); ?>">
                            <div class="mb-6 flex flex-col sm:flex-row items-center gap-3">
                                <label for="destination"
                                    class="block text-sm font-medium text-slate-600">Destination</label>
                                <select name="destination" id="destination"
                                    class="rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm"
                                    onchange="this.form.submit()">
                                    <option value="">All Destinations</option>
                                    <?php foreach ($destinations as $dest): ?>
                                        <option value="<?= htmlspecialchars($dest['id']); ?>"
                                            <?= isset($_POST['destination']) && $_POST['destination'] == $dest['id'] ? 'selected' : ''; ?>>
                                            <?= htmlspecialchars($dest['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </form>


                        <!-- <div>
                                        <label for="duration" class="block text-sm font-medium text-slate-600">Duration (days)</label>
                                        <input type="number" id="duration" placeholder="e.g. 7" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-slate-600">Price per person (₹)</label>
                                        <div class="flex items-center gap-2 mt-1">
                                            <input type="number" placeholder="Min" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                            <span>-</span>
                                            <input type="number" placeholder="Max" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                        </div>
                                    </div>

                                    <div>
                                        <label class="block text-sm font-medium text-slate-600">Theme</label>
                                        <div class="mt-2 space-y-2">
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Family</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Honeymoon</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Adventure</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Religious</label></div>
                                        </div>
                                    </div> -->
                        <!-- 
                                    <button class="w-full bg-sky-600 text-white font-bold py-2 px-4 rounded-md hover:bg-sky-700 transition-colors">Apply Filter</button> -->
                    </div>
                </div>
            </aside>

            <!-- Right Content: Package Grid -->
            <div class="w-full lg:w-4/4">
                <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">

                    <?php foreach ($packages as $package):
                        $title = htmlspecialchars($package['title']);
                        $destination = htmlspecialchars($package['destination_name']);
                        $nights = isset($package['duration_nights']) ? $package['duration_nights'] : 0;
                        $days = isset($package['duration_days']) ? $package['duration_days'] : 0;
                        $price = isset($package['price']) ? number_format($package['price'], 2) : '0.00';

                        $images = get_package_images($package['package_id']);
                        $image = !empty($images['cover'])
                            ? $images['cover']
                            : 'https://placehold.co/600x400/10b981/ffffff?text=' . urlencode($destination);



                        $inclusions = isset($package['inclusions']) ? $package['inclusions'] : [];
                        ?>
                        <div
                            class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden flex flex-col hover:shadow-xl transition-shadow duration-300">
                            <img src="<?= $image; ?>" alt="<?= $title; ?>" class="w-full h-48 object-cover">
                            <div class="p-4 flex flex-col flex-grow">
                                <h3 class="text-xl font-bold text-slate-800"><?= $title; ?></h3>
                                <p class="text-sm text-slate-500 mt-1"><?= $nights ?> Nights / <?= $days ?> Days</p>
                                <div class="mt-3 text-xs text-slate-600 space-y-1">
                                    <?php foreach ($inclusions as $inc): ?>
                                        <p>✓ <?= htmlspecialchars($inc['inclusion_text']); ?></p>
                                    <?php endforeach; ?>
                                </div>
                                <div class="mt-auto pt-4">
                                    <p class="text-sm text-slate-500">Starts from</p>
                                    <p class="text-2xl font-bold text-orange-600">
                                        ₹<?= get_lowest_price('package', $package['package_id'])['price_with_markup']; ?>
                                        <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                    <button
                                        onclick="window.location.href='<?= base_url('package-details/' . $package['package_id'] . ''); ?>'"
                                        class="mt-3 w-full bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors">View
                                        Details</button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>


                </div>
            </div>
        </div>
    </div>
</main>