<script>
    $(document).ready(function() {
        $('#mytable').DataTable({
          dom: 'Bfrtip',
        buttons: [
          { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          { extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]});
    } );
</script>
<table class="table table-bordered" id="mytable">
  <thead>
    <tr>
      <th>
          <div class="checkbox-fade fade-in-primary d-">
              <label>
                  <input type="checkbox" value="" id="checkedAll" class="">
              </label>
          </div>
      </th> 
      <th scope="col">S.No.</th>
      <th scope="col">Name</th>
      <th scope="col">Description</th>
      <th scope="col">Icon</th>
      <th scope="col">Created</th>
      <th scope="col">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i=1; foreach($list as $val){
      ?>
    <tr>
      <td>
          <div class="checkbox-fade fade-in-primary d-">
              <label>
                  <input type="checkbox" name="pro[]" value="<?= $val['id'] ?>" class="delete_checkbox checkSingle" id="multiple_delete<?=  $val['id']; ?>">
              </label>
          </div>
      </td> 
      <th scope="row"><?= $i++; ?></th>
      <td><?= $val['name']; ?></td>
      <td><?= read_more_less($val['description'],20,$val['id']); ?></td>
      <td><?= date('d-m-Y',strtotime($val['created']));?></td>
      <td>
        <?php if(!empty($val['icon'])) { ?>
            <img src="<?= base_url('assets/uploads/'.$val['icon'].'');?>" alt="<?= $val['icon'];?>" height="50" width="50">
        <?php } ?> 
      </td>
      <td>
        <a href="javascript:void(0)" class="btn btn-primary btn-sm" onclick="editNewsCity(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editNewsCityModal">Edit</a>
         <?php if($val['is_disable'] == '0'){ ?>
            <a href="javascript:void(0)" class="btn btn-success btn-sm" onclick="suspend(<?= $val['id']; ?>)">Disable</a>
        <?php } else{ ?>
            <a href="javascript:void(0)" class="btn btn-danger btn-sm" onclick="unsuspend(<?= $val['id']; ?>)">Enable</a>
        <?php } ?>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>
<script>
//multiple delete
$("#checkedAll").change(function() {
    if (this.checked) {
        $(".checkSingle").each(function() {
          $(this).closest('tr').addClass('removeRow');
          this.checked=true;
        });
    } else {
        $(".checkSingle").each(function() {
            this.checked=false;
        });
    }
});
$('.delete_checkbox').click(function(){
    if($(this).is(':checked'))
    {
    $(this).closest('tr').addClass('removeRow');
    }
    else
    {
    $(this).closest('tr').removeClass('removeRow');
    }
});
$('#delete_all').click(function(){
    var checkbox = $('.delete_checkbox:checked');
    var table = 'news_city';
        if(checkbox.length > 0)
        {
          if (confirm('Are you sure?') == true) {
            var checkbox_value = [];
            $(checkbox).each(function(){
                checkbox_value.push($(this).val());
            });
            $.ajax({
                url:"<?= base_url('dashboard/multipleDel'); ?>",
                method:"POST",
                data:{checkbox_value:checkbox_value,table:table},
                success:function(res)
                {
                  $('.removeRow').fadeOut(1500);
                }
            })
          }
        }
        else
        {
        alert('Select atleast one record');
        }
})
function suspend(id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?= base_url('Master/suspendNewsCity'); ?>",
        method: "POST",
        data: {
            id:id
        },
        success:function(res){
          $('#tb').html(res);
        }
    });
  }
};
function unsuspend(id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?= base_url('Master/unsuspendNewsCity'); ?>",
        method: "POST",
        data: {
            id:id
        },
        success:function(res){
          $('#tb').html(res);
        }
    });
  }
};
</script>