<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          aaSorting: [[0, 'desc']],
        buttons: [
        //  { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          //{ extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
         // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]
        });
      }else{
        $('#mytable').DataTable({
          aaSorting: [[0, 'desc']],
        });
      }
        if($('#usertype').val() == 'staff')
        {
            $('.edit-btn').remove();
            $('.add-btn').remove();
        }
    } );
</script>
<table class="table table-bordered table-hover align-middle">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Package</th>
            <th>Price</th>
            <th>Agent</th>
            <th>Email</th>
            <th>Mobile</th>
            <th>Travel Date</th>
            <th>Travelers</th>
            <th>Message</th>
            <th>Status</th>
            <th>Inquiry Date</th>
        </tr>
    </thead>
    <tbody>
        <?php $i=1; foreach($list as $val): ?>
        <tr>
            <td><?= $i++; ?></td>

            <!-- Package -->
            <td>
                <div class="font-bold"><?= $val['package_title'] ?? 'N/A'; ?></div>
            </td>
            <td><?= $val['price'] ?? ''; ?></td>

            <!-- Agent -->
            <td><?= $val['agent_name'] ?? 'N/A'; ?></td>
            <td><?= $val['email'] ?? 'N/A'; ?></td>
            <td><?= $val['mobile'] ?? 'N/A'; ?></td>

            <!-- Travel Date -->
            <td><?= !empty($val['travel_date']) ? date("d-m-Y", strtotime($val['travel_date'])) : '-'; ?></td>

            <!-- Travelers -->
            <td>
                <?php 
                    $adults = $val['adults'] ?? 0;
                    $children = $val['children'] ?? 0;
                    echo "{$adults} Adults";
                    if($children > 0) echo " / {$children} Children";
                ?>
            </td>


            <!-- Message -->
            <td><?= !empty($val['message']) ? nl2br(htmlspecialchars($val['message'])) : '-'; ?></td>

            <!-- Status -->
            <td>
                <?php
                    $status_colors = [
                        'pending' => 'bg-warning text-dark',
                        'confirmed' => 'bg-success text-white',
                        'cancelled' => 'bg-danger text-white',
                        'payment_received' => 'bg-info text-white'
                    ];
                    $status_class = $status_colors[$val['status']] ?? 'bg-secondary text-white';
                ?>
                <span class="badge <?= $status_class ?>"><?= ucfirst($val['status'] ?? 'pending'); ?></span>
                
                <select class="status-dropdown form-select form-select-sm" data-id="<?= $val['id']; ?>">
                    <option value="pending" <?= $val['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="confirmed" <?= $val['status'] == 'confirmed' ? 'selected' : ''; ?>>Confirmed</option>
                    <option value="cancelled" <?= $val['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                    <option value="payment_received" <?= $val['status'] == 'payment_received' ? 'selected' : ''; ?>>Payment Received</option>
                </select>
            </td>

            <!-- Inquiry Date -->
            <td><?= !empty($val['created_at']) ? date("d-m-Y", strtotime($val['created_at'])) : '-'; ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>





<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'users';
    var column = 'is_suspended';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'role'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('users/viewUser/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};


$(document).ready(function(){
    $('.status-dropdown').change(function(){
        var inquiryId = $(this).data('id');
        var newStatus = $(this).val();

        $.ajax({
            url: "<?php echo base_url('package_inquiry/update_inquiry_status'); ?>",
            method: "POST",
            data: {
                id: inquiryId,
                status: newStatus
            },
            dataType:'json',
            success:function(res){
              if(res.return)
              {
                $('#tb').load('<?= base_url('package_inquiry/viewPackageInquiry'); ?>');
                toastr.success(res.msg);
              }
              else
              {
                toastr.error(res.msg);
              }
              
            }
        });
    });
});
</script>