<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website_model extends CI_Model
{

    public function get_all_hotels()
    {
        $this->db->select('p.*, GROUP_CONCAT(DISTINCT a.amenity_name) as amenities, GROUP_CONCAT(DISTINCT po.policy_text) as policies');
        $this->db->from('properties p');
        $this->db->join('property_amenities a', 'p.id = a.property_id', 'left');
        $this->db->join('property_policies po', 'p.id = po.property_id', 'left');
        $this->db->group_by('p.id');
        return $this->db->get()->result_array();
    }
    public function searchHotels($destination, $checkin, $checkout)
    {
        $this->db->select('
            p.*,
            GROUP_CONCAT(DISTINCT a.amenity_name) AS amenities,
            GROUP_CONCAT(DISTINCT po.policy_text) AS policies
        ');
        $this->db->from('properties p');
        $this->db->join('property_amenities a', 'p.id = a.property_id', 'left');
        $this->db->join('property_policies po', 'p.id = po.property_id', 'left');
        $this->db->join('rooms r', 'r.property_id = p.id', 'inner');
        $this->db->join('room_pricing rp', 'rp.room_id = r.id', 'inner');
        $this->db->join('price_dates pd', 'pd.id = rp.price_date_id', 'inner');

        // 🔍 Search by destination (hotel name or city)
        if (!empty($destination)) {
            $this->db->group_start()
                ->like('p.name', $destination)
                ->or_like('p.city', $destination)
                ->group_end();
        }

        // 📅 Filter by check-in / check-out range
        if (!empty($checkin) && !empty($checkout)) {
            $this->db->where('pd.from_date <=', $checkin);
            $this->db->where('pd.to_date >=', $checkout);
        }

        $this->db->group_by('p.id');
        $query = $this->db->get();
        return $query->result_array();
    }




    // Get single hotel
    public function get_hotel_by_id($id)
    {
        $this->db->select('p.*, GROUP_CONCAT(DISTINCT a.amenity_name) as amenities, GROUP_CONCAT(DISTINCT po.policy_text) as policies, GROUP_CONCAT(DISTINCT po.policy_type) as policy_types');
        $this->db->from('properties p');
        $this->db->join('property_amenities a', 'p.id = a.property_id', 'left');
        $this->db->join('property_policies po', 'p.id = po.property_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->group_by('p.id');
        return $this->db->get()->row_array();
    }

    // Get rooms of a hotel
    public function get_rooms_by_hotel($property_id, $checkin = null, $checkout = null)
    {
        $this->db->select('
            r.*,
            GROUP_CONCAT(DISTINCT ra.amenity_name) AS amenities,
            rp.room_rate,
            pd.from_date,
            pd.to_date
        ');
        $this->db->from('rooms r');
        $this->db->join('room_amenities ra', 'r.id = ra.room_id', 'left');
        $this->db->join('room_pricing rp', 'r.id = rp.room_id', 'left');
        $this->db->join('price_dates pd', 'pd.id = rp.price_date_id', 'left');
        $this->db->where('r.property_id', $property_id);

        // ✅ Apply check-in / check-out filter only if provided
        if (!empty($checkin) && !empty($checkout)) {
            $this->db->where('pd.from_date <=', $checkin);
            $this->db->where('pd.to_date >=', $checkout);
        }

        $this->db->group_by('r.id');
        return $this->db->get()->result_array();
    }


    // Fetch inquiry cart data
    public function get_inquiry_cart($agent_id)
    {
        $this->db->select('ic.id as cart_id,ic.price, r.id as room_id, r.name, r.description');
        $this->db->from('inquiry_cart ic');
        $this->db->join('rooms r', 'ic.room_id = r.id', 'left');
        ;
        $this->db->where('ic.agent_id', $agent_id);
        return $this->db->get()->result_array();
    }

    // Generate booking summary HTML
    public function generate_booking_summary_html($agent_id)
    {
        $html = '<h2 class="text-xl font-bold mb-4">Booking Summary</h2>';
        $cart = $this->get_inquiry_cart($agent_id);
        if (empty($cart))
            return '<h2 class="text-xl font-bold mb-4">Booking Summary</h2><p class="text-center text-gray-500">No rooms added yet.</p>';

        $subtotal = 0;
        $html .= '<div class="space-y-4">';
        foreach ($cart as $room) {
            $room_price = get_current_month_prices('room', $room['room_id'])['markup_prices'][0];
            $subtotal += $room_price;
            $html .= '<div class="flex justify-between items-start border-b pb-2">
                        <div>
                            <p class="font-semibold">' . htmlspecialchars($room['name']) . '</p>
                            <p class="text-sm text-slate-500">' . htmlspecialchars($room['description']) . '</p>
                        </div>
                        <div class="text-right">
                            <p class="font-semibold">₹' . $room_price . '</p>
                            <button class="text-xs text-red-500 hover:underline" onclick="removeFromInquiry(' . $room['cart_id'] . ',' . $room['room_id'] . ')">Remove</button>
                        </div>
                    </div>';
        }
        // $taxes = round($subtotal * 0.18); // 18% tax example
        // $total = $subtotal + $taxes;
        $total = $subtotal;

        $html .= '</div>
                  <div class="border-t my-4"></div>
                  <div class="space-y-2">
                      <div class="flex justify-between text-slate-600">
                          <span>Subtotal</span>
                          <span>₹' . $subtotal . '</span>
                      </div>
                      <div class="flex justify-between text-xl font-bold pt-2">
                          <span>Total Price</span>
                          <span>₹' . $total . '</span>
                      </div>
                  </div>
                  <button class="mt-6 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 px-4 rounded-lg transition-colors" onclick="submitInquiry()">Submit Inquiry</button>';
        return $html;
    }

    public function getPackagesResultData($destination_id = null)
    {
        $this->db->select('
            p.id AS package_id,
            p.destination_id,
            d.name AS destination_name,
            p.title,
            p.slug,
            p.duration_nights,
            p.duration_days,
            p.short_description,
            p.image,
            p.theme_ids
        ');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.is_disable', 0);
        $this->db->order_by('p.id', 'ASC');
        if (!empty($destination_id)) {
            $this->db->where('p.destination_id', $destination_id);
        }

        $packages = $this->db->get()->result_array();

        // Fetch inclusions and themes for each package
        foreach ($packages as &$pkg) {
            // Get inclusions
            $pkg['inclusions'] = $this->db->select('inclusion_text')
                ->from('package_inclusions')
                ->where('package_id', $pkg['package_id'])
                ->get()
                ->result_array();

            // Get themes
            $pkg['themes'] = [];
            if (!empty($pkg['theme_ids'])) {
                $theme_ids = explode(',', $pkg['theme_ids']);
                $themes = $this->db->select('name')
                    ->from('themes')
                    ->where_in('id', $theme_ids)
                    ->get()
                    ->result_array();

                // Extract theme names as plain array
                $pkg['themes'] = array_column($themes, 'name');
            }
        }

        return $packages;
    }


    public function getPackageById($id)
    {
        $this->db->select('
            p.id AS package_id,
            p.destination_id,
            d.name AS destination_name,
            p.title,
            p.slug,
            p.duration_nights,
            p.duration_days,
            p.short_description,
            p.image,
            p.theme_ids,
            p.itinerary,
            p.hotels
        ');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->where('p.is_disable', 0);

        $package = $this->db->get()->row_array();

        if ($package) {
            // Get inclusions
            $package['inclusions'] = $this->db->select('inclusion_text')
                ->from('package_inclusions')
                ->where('package_id', $package['package_id'])
                ->get()
                ->result_array();

            // Optionally, get theme names (if you have a themes table)
            if (!empty($package['theme_ids'])) {
                $theme_ids = explode(',', $package['theme_ids']);
                $package['themes'] = $this->db->select('name')
                    ->from('themes')
                    ->where_in('id', $theme_ids)
                    ->get()
                    ->result_array();
            } else {
                $package['themes'] = [];
            }
        }

        return $package;
    }

    public function getRoomImages($room_id)
    {
        return $this->db
            ->where('room_id', $room_id)
            ->get('room_image')
            ->result_array();
    }



}
