<?php


class User_model extends CI_Model
{
    public function getUserResultData($where = null)
    {
        $this->db
            ->select('t1.*,t2.role_name,t3.name as agency_name,t1.markup_type,t1.markup_value')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->join('agency t3', 't3.id = t1.agency_id', 'left');
        if (isset($where) && $where !== null) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        return $query->result_array();
    }
    public function getUserRowData($id)
    {
        $this->db
            ->select('t1.*,t2.role_name,t3.name as agency_name')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->join('agency t3', 't3.id = t1.agency_id', 'left')
            ->where('t1.id', $id);

        $query = $this->db->get();
        return $query->row_array();
    }

    public function getParentsByChildId($child_user_id)
    {
        $this->db
            ->select('t1.*, t2.role_name')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->where('t1.role_id', 4)
            ->where("FIND_IN_SET(" . intval($child_user_id) . ", t1.child_user_ids) >", 0);

        $query = $this->db->get();
        return $query->result_array();
    }


    public function getStudentResultData()
    {
        $this->db
            ->select('t1.*, t2.role_name, t3.board_name')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->join('boards t3', 't3.id = t1.board_id', 'left')
            ->where('BINARY t2.role_name = "student"', null, false); // Case-sensitive

        $query = $this->db->get();
        return $query->result_array();
    }

    public function getParentsResultData()
    {
        $this->db
            ->select('t1.*')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->where('BINARY t2.role_name = "parent"', null, false); // Case-sensitive

        $query = $this->db->get();
        return $query->result_array();
    }
    public function getParentResultData()
    {
        $this->db
            ->select('t1.*, t2.role_name, t3.board_name')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->join('boards t3', 't3.id = t1.board_id', 'left')
            ->where('BINARY t2.role_name = "parent"', null, false);

        $query = $this->db->get();
        return $query->result_array();
    }



}

?>