
<!-- Main Content -->
<main class="flex-grow">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-4xl font-bold text-slate-800">My <?= $title; ?></h1>
        </div>

        <!-- Filters -->
        <!-- <div class="bg-white p-4 rounded-lg shadow-md border border-slate-200 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <input type="text" placeholder="Search by Ref ID, Client..." class="w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                <select class="w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                    <option>All Booking Types</option>
                    <option>Hotel</option>
                    <option>Package</option>
                </select>
                <select class="w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                    <option>All Statuses</option>
                    <option>Confirmed</option>
                    <option>Pending</option>
                    <option>Cancelled</option>
                </select>
                <button class="w-full bg-sky-600 text-white font-bold py-2 px-4 rounded-md hover:bg-sky-700 transition-colors">Search</button>
            </div>
        </div> -->

        <!-- Inquiries Table -->
        <div class="bg-white rounded-lg shadow-md border border-slate-200 overflow-x-auto">
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Property</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Inquiry Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Rooms</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Total Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    <?php $i = 1; if(!empty($list)): ?>
                        <?php foreach($list as $val): ?>
                            <tr class="hover:bg-slate-50 transition-all">

                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800">
                                    <div class="font-bold"><?= $val['property_name'] ?></div>
                                    <div class="text-xs text-slate-500"><?= $val['property_address']; ?></div>
                                </td>
                                <!-- Created Date -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500">
                                    <?= !empty($val['created']) ? date("d-m-Y", strtotime($val['created'])) : '-'; ?>
                                </td>

                                <!-- Room Details -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-700">
                                    <?php if(!empty($val['rooms']) && is_array($val['rooms'])): ?>
                                        <ul class="list-disc ml-4 space-y-1">
                                            <?php foreach($val['rooms'] as $room): ?>
                                                <li>
                                                    <span class="font-medium"><?= htmlspecialchars($room['room_name'] ?? 'Room'); ?></span>
                                                    <span class="text-xs text-slate-500"> (₹<?= number_format($room['price'] ?? 0, 2); ?>)</span>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php else: ?>
                                        <span class="text-xs text-rose-500">No rooms</span>
                                    <?php endif; ?>
                                </td>

                                <!-- Total Amount -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-slate-800">
                                    ₹<?= number_format($val['total_amount'] ?? 0, 2); ?>
                                </td>

                                <!-- Status -->
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $status = strtolower($val['status'] ?? '');
                                        $statusColor = [
                                            'pending'   => 'bg-amber-100 text-amber-800',
                                            'confirmed' => 'bg-green-100 text-green-800',
                                            'cancelled' => 'bg-rose-100 text-rose-800'
                                        ];
                                        $colorClass = $statusColor[$status] ?? 'bg-slate-100 text-slate-800';
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $colorClass; ?>">
                                        <?= !empty($val['status']) ? ucfirst(htmlspecialchars($val['status'])) : 'Unknown'; ?>
                                    </span>
                                </td>




                                
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" class="text-center py-6 text-slate-500 text-sm">
                                No records found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>

            </table>
        </div>

        <!-- Package Inquiries Table -->
        <div class="mt-8 bg-white rounded-lg shadow-md border border-slate-200 overflow-x-auto">
            <h2 class="text-lg font-bold px-6 py-4 border-b border-slate-200 text-slate-800">Package Inquiries</h2>
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Package</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Inquiry Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Travelers</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Message</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    <?php if(!empty($package_inquiries)): ?>
                        <?php foreach($package_inquiries as $inq): ?>
                            <tr class="hover:bg-slate-50 transition-all">

                                <!-- Package Name -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800">
                                    <?= htmlspecialchars($inq['package_title'] ?? '-'); ?>
                                </td>

                                <!-- Package Name -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-800">
                                    <?= htmlspecialchars($inq['price'] ?? '-'); ?>
                                </td>

                                <!-- Inquiry Date -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500">
                                    <?= !empty($inq['created_at']) ? date("d-m-Y", strtotime($inq['created_at'])) : '-'; ?>
                                </td>

                                <!-- Travelers -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-700">
                                    <?php 
                                        $adults = $inq['adults'] ?? 0; 
                                        $children = $inq['children'] ?? 0; 
                                    ?>
                                    <span><?= $adults + $children ?> (<?= $adults ?> Adults, <?= $children ?> Children)</span>
                                </td>

                                <!-- Message -->
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">
                                    <?= !empty($inq['message']) ? htmlspecialchars($inq['message']) : '-'; ?>
                                </td>

                                <!-- Status -->
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $status = strtolower($inq['status'] ?? '');
                                        $statusColor = [
                                            'pending'   => 'bg-amber-100 text-amber-800',
                                            'confirmed' => 'bg-green-100 text-green-800',
                                            'cancelled' => 'bg-rose-100 text-rose-800'
                                        ];
                                        $colorClass = $statusColor[$status] ?? 'bg-slate-100 text-slate-800';
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $colorClass; ?>">
                                        <?= !empty($inq['status']) ? ucfirst(htmlspecialchars($inq['status'])) : 'Unknown'; ?>
                                    </span>
                                </td>

                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center py-6 text-slate-500 text-sm">
                                No package inquiries found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>


    </div>
</main>
