<!-- Price Dates list table -->
<table class="table table-hover align-middle" id="priceDatesTable">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Name</th>
            <th>From Date</th>
            <th>To Date</th>
            <th>Remarks</th>
            <th>Created</th>
            <th class="text-center">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1; foreach($list as $val) { 
            $name      = isset($val['name']) ? $val['name'] : '';
            $from_date = isset($val['from_date']) ? date('d M, Y', strtotime($val['from_date'])) : '-';
            $to_date   = isset($val['to_date']) ? date('d M, Y', strtotime($val['to_date'])) : '-';
            $remarks   = !empty($val['remarks']) ? $val['remarks'] : '-';
            $created   = isset($val['created_at']) ? date('d M, Y', strtotime($val['created_at'])) : '-';
        ?>
        <tr>
            <td><?= $i++; ?></td>
            <td><i class="bi bi-calendar-week me-1"></i><?= htmlspecialchars($name); ?></td>
            <td><?= htmlspecialchars($from_date); ?></td>
            <td><?= htmlspecialchars($to_date); ?></td>
            <td><?= htmlspecialchars($remarks); ?></td>
            <td><?= htmlspecialchars($created); ?></td>

            <td class="text-center">
                <a href="javascript:void(0)" class="btn btn-sm btn-outline-primary edit-btn"
                   onclick="editData(<?= $val['id']; ?>)" title="Edit">
                   <i class="bi bi-pencil-square"></i>
                </a>

                <?php if ($val['is_disable'] == '0') { ?>
                    <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                       onclick="changeStatus(<?= $val['id']; ?>, '1')" title="Disable">
                       <i class="bi bi-x-circle"></i>
                    </a>
                <?php } else { ?>
                    <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                       onclick="changeStatus(<?= $val['id']; ?>, '0')" title="Enable">
                       <i class="bi bi-check-circle"></i>
                    </a>
                <?php } ?>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<!-- JS: DataTables init and tooltips -->
<script>
$(document).ready(function () {
    // bootstrap tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    tooltipTriggerList.map(function (el) { return new bootstrap.Tooltip(el) })

    const isAdmin = $('#usertype').val() === 'admin';

    $('#priceDatesTable').DataTable({
        dom: isAdmin ? 'Bfrtip' : 'frtip',
        aaSorting: [[0, 'desc']],
        pageLength: 25,
        columnDefs: [
            { orderable: false, targets: -1 } // disable sorting on action column
        ],
        buttons: isAdmin ? [
            { extend: 'excel', className: 'btn btn-sm btn-success', text: '<i class="bi bi-file-earmark-excel"></i> Excel', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'csv',  className: 'btn btn-sm btn-primary', text: '<i class="bi bi-filetype-csv"></i> CSV', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'pdf',  className: 'btn btn-sm btn-danger', text: '<i class="bi bi-file-earmark-pdf"></i> PDF', exportOptions: { columns: [0,1,2,3,4,5] } }
        ] : []
    });

    // hide edit/add for staff
    if ($('#usertype').val() === 'staff') {
        $('.edit-btn').remove();
        $('.add-btn').remove();
    }
});

function changeStatus(id, type) {
  if (confirm('Are you sure you want to change status?')) {
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:'price_dates',
            column:'is_disable',
            module:'price dates'
        },
        dataType:'json',
        success:function(res){
          if(res.return) {
            $("#tb").load("<?= base_url('price_dates/viewPriceDates/') ?>")
            toastr.success(res.msg);
          } else {          
            toastr.error(res.msg);
          }
        }
    });
  }
}
</script>
