<style>
    th, td {
      text-align: center;
      vertical-align: middle;
    }
    .permission-group {
      background-color: #f8f9fa;
      font-weight: bold;
    }
    .sticky-col {
      position: sticky;
      left: 0;
      background: white;
      z-index: 1;
    }
  </style>

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <form id="assign-permission-form">
                <div class="table-responsive">
                  <table class="table table-bordered">
                    <thead class="table-light">
                      <tr>
                        <th class="sticky-col">Modules / Permissions</th>
                        <?php foreach($roles as $role){ ?>
                          <th><?= $role['role_name']; ?></th>
                        <?php } ?>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($permissions as $module => $module_permissions): ?>
                        <!-- Module Name Row + Check All -->
                        <tr class="permission-group">
                          <td class="sticky-col fw-bold"><?= ucfirst($module); ?></td>
                          <?php foreach ($roles as $role): ?>
                            <td>
                              <input 
                                type="checkbox" 
                                class="check-all-module form-check-input" 
                                data-module="<?= strtolower(preg_replace('/\s+/', '_', $module)); ?>" 
                                data-role="<?= $role['id']; ?>"
                              >
                              <small class="d-block">All</small>
                            </td>
                          <?php endforeach; ?>
                        </tr>

                        <!-- Individual Permissions -->
                        <?php foreach ($module_permissions as $perm): ?>
                          <tr>
                            <td class="sticky-col">- <?= $perm['name']; ?></td>
                            <?php foreach ($roles as $role): ?>
                              <td>
                                <input 
                                  class="form-check-input permission-checkbox module-<?= strtolower(preg_replace('/\s+/', '_', $module)); ?> role-<?= $role['id']; ?>" 
                                  type="checkbox" 
                                  name="permissions[<?= $role['id']; ?>][]" 
                                  value="<?= $perm['id']; ?>"
                                  <?= in_array($perm['id'], $role['assigned_permissions'] ?? []) ? 'checked' : '' ?>
                                >
                              </td>
                            <?php endforeach; ?>
                          </tr>
                        <?php endforeach; ?>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
                <button type="submit" class="btn btn-primary mt-3">Save</button>
              </form>
            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
<script>
  $(document).on('change', '.check-all-module', function() {
    var module = $(this).data('module');
    var roleId = $(this).data('role');
    var isChecked = $(this).is(':checked');

    $('.module-' + module + '.role-' + roleId).prop('checked', isChecked);
  });

  $(document).ready(function() {
    $('#assign-permission-form').on('submit', function(e) {
      e.preventDefault(); // prevent normal form submit

      $.ajax({
        url: '<?= base_url('assign_permission/save_assign_permissions') ?>', // update this URL to your controller method
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        success: function(response) {
          if (response.status === 'success') {
            alert('Permissions updated successfully!');
          } else {
            alert('Something went wrong. Please try again.');
          }
        },
        error: function(xhr, status, error) {
          console.log(xhr.responseText);
          alert('AJAX Error: ' + error);
        }
      });
    });
  });
</script>

