<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inquiry_model extends CI_Model {

public function getInquiryResultData($where=null) {
    // Fetch inquiry + agent details
    $this->db->select("i.*, a.fullname as agent_name, a.email, a.mobile");
    $this->db->from("inquiries i");
    $this->db->join("users a", "a.id = i.agent_id", "left");
    $this->db->order_by("i.id", "DESC");
    if(isset($where) && $where!==null){
        $this->db->where($where);
    }
    $inquiries = $this->db->get()->result_array();

    foreach ($inquiries as &$inq) {
        // Get property name (all rooms belong to the same property)
        $this->db->select("p.name as property_name,p.address as property_address");
        $this->db->from("inquiry_rooms ir");
        $this->db->join("rooms r", "r.id = ir.room_id", "left");
        $this->db->join("properties p", "p.id = r.property_id", "left");
        $this->db->where("ir.inquiry_id", $inq['id']);
        $this->db->limit(1);
        $property = $this->db->get()->row_array();
        $inq['property_name'] = $property['property_name'] ?? '';
        $inq['property_address'] = $property['property_address'] ?? '';

        // Fetch room details (without property name)
        $this->db->select("ir.id, ir.price, r.name as room_name, GROUP_CONCAT(DISTINCT ra.amenity_name) as amenities");
        $this->db->from("inquiry_rooms ir");
        $this->db->join("rooms r", "r.id = ir.room_id", "left");
        $this->db->join("room_amenities ra", "r.id = ra.room_id", "left");
        $this->db->where("ir.inquiry_id", $inq['id']);
        $this->db->group_by("ir.id");
        $inq['rooms'] = $this->db->get()->result_array();
    }

    return $inquiries;
}


public function getPackageInquiryResultData($where=null) {
    $this->db->select("i.*, a.fullname as agent_name, a.email, a.mobile,p.title as package_title");
    $this->db->from("package_inquiries i");
    $this->db->join("users a", "a.id = i.agent_id", "left");
    $this->db->join("packages p", "p.id = i.package_id", "left");
    $this->db->order_by("i.id", "DESC");
    if(isset($where) && $where!==null){
        $this->db->where($where);
    }
    $inquiries = $this->db->get()->result_array();



    return $inquiries;
}



}
