<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room_pricing extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
        $this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title']      = 'Room Pricing';
        $data['properties'] = $this->model->getResultData('properties', []); 
        $data['rooms']      = $this->model->getResultData('rooms', []);
        $data['price_dates']      = $this->model->getResultData('price_dates', ['is_disable'=>0]);
        $page = 'room_pricing/index';
        $this->header_and_footer($page, $data);
    }

    public function addPricing()
    {
        $room_id       = $this->input->post('room_id');
        $property_id   = $this->input->post('property_id');
        $price_dates   = $this->input->post('price_date_id');
        $prices        = $this->input->post('price');

        if (empty($room_id) || empty($price_dates) || empty($prices)) {
            echo json_encode(['return' => false, 'msg' => 'Missing required fields']);
            return;
        }

        $inserted = 0;
        $skipped  = 0;

        foreach ($price_dates as $i => $price_date_id) {
            $price = isset($prices[$i]) ? $prices[$i] : 0;

            // check if already exists for same room + date range
            $exists = $this->model->countData('room_pricing', [
                'room_id'       => $room_id,
                'price_date_id' => $price_date_id
            ]);

            if ($exists > 0) {
                $skipped++;
                continue;
            }

            $data = [
                'room_id'       => $room_id,
                'price_date_id' => $price_date_id,
                'price'         => $price,
                'is_disable'    => 0,
            ];

            if ($this->model->add('room_pricing', $data)) {
                $inserted++;
            }
        }

        // log only once
        if ($inserted > 0) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $room_id,
                'add',
                'Room Pricing (Multiple Date Wise)'
            );
        }

        if ($inserted > 0 && $skipped == 0) {
            $msg = 'All prices added successfully.';
        } elseif ($inserted > 0 && $skipped > 0) {
            $msg = "Some prices added successfully. ($skipped duplicate skipped)";
        } else {
            $msg = 'No new pricing added (already exists for selected date ranges).';
        }

        echo json_encode(['return' => ($inserted > 0), 'msg' => $msg]);
    }


    public function viewPricing()
    {
        $data['list'] = $this->room_model->getRoomPricingResultData(); 
        $this->load->view('room_pricing/tb', $data);
    }

    public function editPricing()
    {
        $room_id = $_POST['id'];

        // Get all room pricing for this room
        $this->db
            ->select('t1.id as pricing_id, t1.price, t1.price_date_id, t2.name as price_date_name, t2.from_date, t2.to_date, t3.id as property_id, t4.name as room_name')
            ->from('room_pricing t1')
            ->join('price_dates t2', 't2.id = t1.price_date_id', 'left')
            ->join('rooms t4', 't4.id = t1.room_id', 'left')
            ->join('properties t3', 't3.id = t4.property_id', 'left')
            ->where('t1.room_id', $room_id);

        $pricing = $this->db->get()->result_array();

        $response = [
            'room_id'     => $room_id,
            'property_id' => isset($pricing[0]['property_id']) ? $pricing[0]['property_id'] : null,
            'room_name'   => isset($pricing[0]['room_name']) ? $pricing[0]['room_name'] : null,
            'prices'      => $pricing // multiple date-price rows
        ];

        echo json_encode($response);
    }


public function updatePricing()
{
    if (!isset($_POST['room_id']) || empty($_POST['room_id'])) {
        echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
        return;
    }

    $room_id        = $_POST['room_id'];
    $property_id    = $_POST['property_id'];
    $pricing_ids    = $_POST['pricing_id'] ?? [];
    $price_date_ids = $_POST['price_date_id'] ?? [];
    $prices         = $_POST['price'] ?? [];

    if (empty($price_date_ids) || empty($prices)) {
        echo json_encode(['return' => false, 'msg' => 'Please provide at least one price entry']);
        return;
    }

    // Step 1: Get existing pricing IDs for this room
    $existing_ids = $this->db->select('id')->from('room_pricing')->where('room_id', $room_id)->get()->result_array();
    $existing_ids = array_column($existing_ids, 'id');

    $submitted_ids = array_filter($pricing_ids); // IDs from form
    $to_delete_ids = array_diff($existing_ids, $submitted_ids); // IDs to delete

    // Step 2: Delete removed rows
    if (!empty($to_delete_ids)) {
        $this->db->where_in('id', $to_delete_ids)->delete('room_pricing');
    }

    // Step 3: Update or insert
    $success = true;

    foreach($price_date_ids as $index => $price_date_id) {
        $pricing_id = $pricing_ids[$index] ?? null;
        $price      = $prices[$index];

        $data = [
            'room_id'       => $room_id,
            'price_date_id' => $price_date_id,
            'price'         => $price
        ];

        if ($pricing_id) {
            // Update existing row
            $updated = $this->model->edit('room_pricing', $data, ['id' => $pricing_id]);
        } else {
            // Insert new row
            $updated = $this->model->add('room_pricing', $data);
        }

        if (!$updated) $success = false;
    }

    if ($success) {
        $this->createLog(
            $this->session->userdata('id'),
            $this->session->userdata('role'),
            $room_id,
            'edit',
            'Room Pricing'
        );

        echo json_encode(['return' => true, 'msg' => 'Room Pricing Updated Successfully']);
    } else {
        echo json_encode(['return' => false, 'msg' => 'Update Failed for one or more entries']);
    }
}


    public function getRoomsByProperty()
    {
        $property_id = $this->input->post('property_id');
        $rooms = $this->model->getResultData('rooms', ['property_id' => $property_id]);

        $options = '<option value="">Select Room</option>';
        foreach($rooms as $room){
            $options .= '<option value="'.$room['id'].'">'.$room['name'].'</option>';
        }
        echo $options;
    }

}
