<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package_pricing extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    private function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title']        = 'Package Pricing';
        $data['packages']     = $this->model->getResultData('packages', ['is_disable' => 0]);
        $data['price_dates']  = $this->model->getResultData('price_dates', ['is_disable' => 0]);

        $page = 'package_pricing/index';
        $this->header_and_footer($page, $data);
    }

    /** -------------------------------
     *  ADD PACKAGE PRICING
     *--------------------------------*/
    public function addPricing()
    {
        $package_id   = $this->input->post('package_id');
        $price_dates  = $this->input->post('price_date_id');
        $prices       = $this->input->post('price');

        if (empty($package_id) || empty($price_dates) || empty($prices)) {
            echo json_encode(['return' => false, 'msg' => 'Missing required fields']);
            return;
        }

        $inserted = 0;
        $skipped  = 0;

        foreach ($price_dates as $i => $price_date_id) {
            $price = isset($prices[$i]) ? $prices[$i] : 0;

            // check if already exists for same package + date range
            $exists = $this->model->countData('package_pricing', [
                'package_id'    => $package_id,
                'price_date_id' => $price_date_id
            ]);

            if ($exists > 0) {
                $skipped++;
                continue;
            }

            $data = [
                'package_id'    => $package_id,
                'price_date_id' => $price_date_id,
                'price'         => $price,
                'is_disable'    => 0,
            ];

            if ($this->model->add('package_pricing', $data)) {
                $inserted++;
            }
        }

        // log only once
        if ($inserted > 0) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $package_id,
                'add',
                'Package Pricing (Multiple Date Wise)'
            );
        }

        if ($inserted > 0 && $skipped == 0) {
            $msg = 'All prices added successfully.';
        } elseif ($inserted > 0 && $skipped > 0) {
            $msg = "Some prices added successfully. ($skipped duplicate skipped)";
        } else {
            $msg = 'No new pricing added (already exists for selected date ranges).';
        }

        echo json_encode(['return' => ($inserted > 0), 'msg' => $msg]);
    }

    /** -------------------------------
     *  VIEW PACKAGE PRICING
     *--------------------------------*/
    public function viewPricing()
    {
        $data['list'] = $this->package_model->getPackagePricingResultData(); 
        $this->load->view('package_pricing/tb', $data);
    }

    /** -------------------------------
     *  EDIT PACKAGE PRICING (FETCH DATA)
     *--------------------------------*/
    public function editPricing()
    {
        $package_id = $_POST['id'];

        // Get all pricing for this package
        $this->db
            ->select('t1.id as pricing_id, t1.price, t1.price_date_id, t2.name as price_date_name, t2.from_date, t2.to_date, t3.id as package_id, t3.title as package_name')
            ->from('package_pricing t1')
            ->join('price_dates t2', 't2.id = t1.price_date_id', 'left')
            ->join('packages t3', 't3.id = t1.package_id', 'left')
            ->where('t1.package_id', $package_id);

        $pricing = $this->db->get()->result_array();

        $response = [
            'package_id'   => $package_id,
            'package_name' => isset($pricing[0]['package_name']) ? $pricing[0]['package_name'] : null,
            'prices'       => $pricing
        ];

        echo json_encode($response);
    }

    /** -------------------------------
     *  UPDATE PACKAGE PRICING
     *--------------------------------*/
    public function updatePricing()
    {
        if (!isset($_POST['package_id']) || empty($_POST['package_id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $package_id     = $_POST['package_id'];
        $pricing_ids    = $_POST['pricing_id'] ?? [];
        $price_date_ids = $_POST['price_date_id'] ?? [];
        $prices         = $_POST['price'] ?? [];

        if (empty($price_date_ids) || empty($prices)) {
            echo json_encode(['return' => false, 'msg' => 'Please provide at least one price entry']);
            return;
        }

        // Step 1: Get existing pricing IDs for this package
        $existing_ids = $this->db->select('id')->from('package_pricing')->where('package_id', $package_id)->get()->result_array();
        $existing_ids = array_column($existing_ids, 'id');

        $submitted_ids = array_filter($pricing_ids);
        $to_delete_ids = array_diff($existing_ids, $submitted_ids);

        // Step 2: Delete removed rows
        if (!empty($to_delete_ids)) {
            $this->db->where_in('id', $to_delete_ids)->delete('package_pricing');
        }

        // Step 3: Update or insert
        $success = true;

        foreach($price_date_ids as $index => $price_date_id) {
            $pricing_id = $pricing_ids[$index] ?? null;
            $price      = $prices[$index];

            $data = [
                'package_id'    => $package_id,
                'price_date_id' => $price_date_id,
                'price'         => $price
            ];

            if ($pricing_id) {
                $updated = $this->model->edit('package_pricing', $data, ['id' => $pricing_id]);
            } else {
                $updated = $this->model->add('package_pricing', $data);
            }

            if (!$updated) $success = false;
        }

        if ($success) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $package_id,
                'edit',
                'Package Pricing'
            );

            echo json_encode(['return' => true, 'msg' => 'Package Pricing Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed for one or more entries']);
        }
    }
}
