<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Destination extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    // =========================================
    // INDEX PAGE
    // =========================================
    public function index()
    {
        $data['title'] = 'Destinations';
        $page = 'destination/index';
        $this->header_and_footer($page, $data);
    }

    // =========================================
    // ADD DESTINATION
    // =========================================
    public function addDestination()
    {
        $countData = $this->model->countData('destinations', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Destination already exists']);
            return;
        }

        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name'         => $_POST['name'],
            'slug'         => $slug,
            'description'  => $_POST['description'],
        ];

        if ($this->model->add('destinations', $array)) {
            $destination_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $destination_id,
                'add',
                'Destination'
            );

            echo json_encode(['return' => true, 'msg' => 'Destination Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add destination']);
        }
    }

    // =========================================
    // VIEW DESTINATIONS (TABLE LIST)
    // =========================================
    public function viewDestination()
    {
        $data['list'] = $this->model->getResultData('destinations', []); 
        $this->load->view('destination/tb', $data);
    }

    // =========================================
    // EDIT DESTINATION (FETCH DATA)
    // =========================================
    public function editDestination()
    {
        $data = $this->model->getRowData('destinations', ['id' => $_POST['id']]);

        $response = [
            'id'           => $data['id'],
            'name'         => $data['name'],
            'slug'         => $data['slug'],
            'description'  => $data['description'],
        ];

        echo json_encode($response);
    }

    // =========================================
    // UPDATE DESTINATION
    // =========================================
    public function updateDestination()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name'         => $_POST['name'],
            'slug'         => $slug,
            'description'  => $_POST['description'],
        ];

        if ($this->model->edit('destinations', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Destination'
            );

            echo json_encode(['return' => true, 'msg' => 'Destination Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }



    //LINK CITIES


    // 🔹 1. Fetch Suggested Cities (POST)
    public function fetch_cities()
    {
        $destination_id = $this->input->post('destination_id');
        $destination_name = '';

        // Get destination name
        if ($destination_id) {
            $row = $this->db->get_where('destinations', ['id' => $destination_id])->row();
            $destination_name = $row ? $row->name : '';
        }

        if (empty($destination_name)) {
            echo json_encode([]);
            return;
        }

        // Find matching states first
        $states = $this->db->select('id')
            ->like('name', $destination_name)
            ->get('states')
            ->result_array();
        $state_ids = array_column($states, 'id');

        // Fetch matching cities
        $this->db->select('id, name');
        $this->db->from('cities');
        $this->db->group_start();
        $this->db->like('name', $destination_name);
        if (!empty($state_ids)) {
            $this->db->or_where_in('state_id', $state_ids);
        }
        $this->db->group_end();
        $this->db->order_by('name', 'ASC');
        $cities = $this->db->get()->result_array();

        echo json_encode($cities);
    }


    // 🔹 2. Get Already Linked Cities (POST)
    public function get_linked_cities()
    {
        $destination_id = $this->input->post('destination_id');
        $result = $this->db
            ->select('dc.id, dc.city_id, c.name')
            ->from('destination_cities dc')
            ->join('cities c', 'c.id = dc.city_id', 'left')
            ->where('dc.destination_id', $destination_id)
            ->order_by('c.name', 'ASC')
            ->get()
            ->result_array();

        echo json_encode($result);
    }

    // 🔹 3. Save Cities (POST)
    public function save_cities()
    {
        $destination_id = $this->input->post('destination_id');
        $city_ids = $this->input->post('city_ids');

        if (empty($destination_id)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid destination']);
            return;
        }

        $this->db->trans_start();

        // delete old links
        $this->db->where('destination_id', $destination_id)->delete('destination_cities');

        // insert new
        if (!empty($city_ids)) {
            foreach ($city_ids as $cid) {
                $this->db->insert('destination_cities', [
                    'destination_id' => $destination_id,
                    'city_id' => $cid
                ]);
            }
        }

        $this->db->trans_complete();

        if ($this->db->trans_status()) {
            echo json_encode(['status' => 'success', 'message' => 'Cities linked successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Database error']);
        }
    }


}
