<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Assign_permission extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->hasPermission();
    }
    public function hasPermission()
	{
        if (!has_permission('assign_permission_access'))
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	// public function index()
	// {
	// 	$data['title'] = 'Assign Permission';

	// 	// Get roles and permissions
	// 	$roles = $this->model->getResultData('roles', ['is_disable' => 0]);
	// 	$permissions = $this->master_model->get_permissions_grouped_by_module();
	// 	$assigned_permissions = $this->model->getResultData('assign_permission', []);

	// 	// Group assigned permissions by role_id
	// 	$role_permissions_map = [];
	// 	foreach ($assigned_permissions as $ap) {
	// 		$role_permissions_map[$ap['role_id']][] = $ap['permission_id'];
	// 	}

	// 	// Add assigned permissions to each role
	// 	foreach ($roles as &$role) {
	// 		$role['assigned_permissions'] = $role_permissions_map[$role['id']] ?? [];
	// 	}
	// 	unset($role); // break reference

	// 	// Pass data to view
	// 	$data['roles'] = $roles;
	// 	$data['permissions'] = $permissions;

	// 	$page = 'assign_permission/index';
	// 	$this->header_and_footer($page, $data);
	// }

	public function index()
{
    $data['title'] = 'Assign Permission';

    $logged_in_role_id = $this->session->userdata('role_id');

    // Get all active roles
    $roles = $this->model->getResultData('roles', ['is_disable' => 0]);

    // Get all permissions grouped by module
    $permissions = $this->master_model->get_permissions_grouped_by_module();

    // Get all assigned permissions
    $assigned_permissions = $this->model->getResultData('assign_permission', []);

    // Group assigned permissions by role_id
    $role_permissions_map = [];
    foreach ($assigned_permissions as $ap) {
        $role_permissions_map[$ap['role_id']][] = $ap['permission_id'];
    }

    // Filter roles based on permission check
    $filtered_roles = [];
    foreach ($roles as $role) {
        // Add assigned permissions to each role
        $role['assigned_permissions'] = $role_permissions_map[$role['id']] ?? [];

        if ($logged_in_role_id == 1) {
            // Super admin sees all roles
            $filtered_roles[] = $role;
        } else {
            // For other users, remove any role that has assign_permission_access
            if (!has_permission('assign_permission_access',$role['id'])) {
                $filtered_roles[] = $role;
            }
        }
    }

    $data['roles'] = $filtered_roles;
    $data['permissions'] = $permissions;

    $page = 'assign_permission/index';
    $this->header_and_footer($page, $data);
}




	
  
	public function save_assign_permissions() {
		$all_permissions = $this->input->post('permissions'); // [role_id => [permission_ids]]
	
		if (!empty($all_permissions)) {
			foreach ($all_permissions as $role_id => $permission_ids) {
				// Delete old permissions for this role
				$this->db->where('role_id', $role_id);
				$this->db->delete('assign_permission');
	
				// Insert new ones
				if (!empty($permission_ids)) {
					$batch = [];
					foreach ($permission_ids as $pid) {
						$batch[] = [
							'role_id' => $role_id,
							'permission_id' => $pid
						];
					}
					$this->db->insert_batch('assign_permission', $batch);
				}
			}
		}
	
		echo json_encode(['status' => 'success']);
	}
	
	
}
