<table class="table table-hover align-middle" id="pricingTable">

<thead class="table-dark">
<tr>
<th style="width:60px">#</th>
<th>Property</th>
<th>Room</th>
<th style="width:160px">Created</th>
<th class="text-center" style="width:120px">Action</th>
</tr>
</thead>

<tbody>

<?php $i=1; foreach($list as $val): 
$accordionId = "acc".$val['room_id'];
?>

<!-- MAIN ROOM ROW -->
<tr class="bg-light">
<td><?= $i++; ?></td>
<td><?= htmlspecialchars($val['property_name']); ?></td>
<td>

<button class="btn btn-sm btn-outline-secondary w-100 text-start"
data-bs-toggle="collapse"
data-bs-target="#<?= $accordionId; ?>">

<i class="bi bi-chevron-down me-1"></i>
<?= htmlspecialchars($val['room_name']); ?>

</button>

</td>

<td><?= date('d M Y',strtotime($val['created_at'])); ?></td>

<td class="text-center">
<button class="btn btn-sm btn-outline-primary"
onclick="editData(<?= $val['room_id']; ?>)">
<i class="bi bi-pencil"></i>
</button>
</td>
</tr>


<!-- COLLAPSIBLE PRICING ROW -->
<tr class="collapse-row">
<td colspan="5" class="p-0 border-0">

<div id="<?= $accordionId; ?>" class="collapse">

<div class="p-3 bg-white border-top">

<?php if(!empty($val['dates'])): ?>

<?php foreach($val['dates'] as $date): ?>

<div class="card mb-3 shadow-sm">

<div class="card-header bg-secondary text-white py-2">
<strong><?= $date['price_date_name']; ?></strong>
<span class="ms-2 small">
<?= date('d M Y',strtotime($date['from_date'])); ?>
→
<?= date('d M Y',strtotime($date['to_date'])); ?>
</span>
</div>

<div class="card-body p-2">

<table class="table table-sm table-bordered text-center mb-0">

<thead class="table-light">
<tr>
<th>Plan</th>
<th>Room</th>
<th>EB A</th>
<th>EB C</th>
<th>CNB</th>
</tr>
</thead>

<tbody>

<?php foreach($date['plans'] as $plan => $rate): ?>
<tr>
<td><b><?= $plan; ?></b></td>
<td>₹<?= number_format($rate['room_rate']); ?></td>
<td>₹<?= number_format($rate['eb_adult']); ?></td>
<td>₹<?= number_format($rate['eb_child']); ?></td>
<td>₹<?= number_format($rate['cnb']); ?></td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

<?php endforeach; ?>

<?php else: ?>
<div class="text-muted p-2">No pricing found</div>
<?php endif; ?>

</div>
</div>

</td>
</tr>

<?php endforeach; ?>

</tbody>
</table>
