<style>

.pricing-table th,
.pricing-table td{
padding:12px !important;
vertical-align:middle;
}

.pricing-table input{
min-width:95px;
height:42px;
font-size:14px;
text-align:center;
}

.pricing-table select{
min-width:180px;
height:42px;
}

.pricing-wrapper{
overflow:auto;
max-height:480px;
border:1px solid #ddd;
border-radius:8px;
}

.pricing-table thead th{
position:sticky;
top:0;
background:#f8f9fa;
z-index:2;
}

</style>

<main id="main" class="main">

<section class="section">
<div class="row">
<div class="col-lg-12">

<div class="card">
<div class="card-header mb-4">
<div class="row align-items-center">
<div class="col-sm-6">
<h4><?= $title; ?></h4>
</div>
<div class="col-sm-6 text-end">
<button class="btn btn-success" onclick="openAddModal()">
+ Add <?= $title; ?>
</button>
</div>
</div>
</div>

<div class="card-body">
<div id="tb"></div>
</div>

</div>
</div>
</div>
</section>

</main>

<!-- ================= ADD MODAL ================= -->
<div class="modal fade" id="addModal">
<div class="modal-dialog modal-xl modal-dialog-centered">
<div class="modal-content">

<div class="modal-header bg-success text-white">
<h5>Add Pricing</h5>
<button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">

<form id="add-form" class="row g-3">

<div class="col-md-6">
<label>Property</label>
<select class="form-control" id="property_id" name="property_id" required>
<option value="">Select</option>
<?php foreach($properties as $p): ?>
<option value="<?= $p['id']; ?>"><?= $p['name']; ?></option>
<?php endforeach; ?>
</select>
</div>

<div class="col-md-6">
<label>Room</label>
<select class="form-control" id="room_id" name="room_id" required>
<option value="">Select</option>
</select>
</div>

<hr>

<div class="col-12">

<div class="d-flex justify-content-between mb-3">
<h6 class="fw-bold">Pricing Matrix</h6>
<button type="button" class="btn btn-success btn-sm" onclick="addRow('priceBody')">
+ Add Row
</button>
</div>

<div class="pricing-wrapper">

<table class="table table-bordered pricing-table text-center mb-0">

<thead>

<tr>
<th rowspan="2">Date</th>
<th colspan="4">EP</th>
<th colspan="4">CP</th>
<th colspan="4">MAP</th>
<th colspan="4">AP</th>
<th rowspan="2">Action</th>
</tr>

<tr>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
</tr>

</thead>

<tbody id="priceBody"></tbody>

</table>

</div>
</div>

<div class="col-12 text-end">
<button class="btn btn-primary">Save</button>
</div>

</form>

</div>
</div>
</div>
</div>

<!-- ================= EDIT MODAL ================= -->
<div class="modal fade" id="editModal">
<div class="modal-dialog modal-xl modal-dialog-centered">
<div class="modal-content">

<div class="modal-header bg-warning">
<h5>Edit Pricing</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">

<form id="edit-form" class="row g-3">

<input type="hidden" name="id" id="edit_id">

<div class="col-md-6">
<label class="fw-semibold">Property</label>
<select class="form-control" id="e_property_id" name="property_id" required>
<option value="">Select Property</option>
<?php foreach ($properties as $property): ?>
  <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
<?php endforeach; ?>
</select>
</div>

<div class="col-md-6">
<label class="fw-semibold">Room</label>
<select class="form-control" id="e_room_id" name="room_id"></select>
</div>

<hr>

<div class="col-12">

<div class="d-flex justify-content-between align-items-center mb-3">
<h6 class="fw-bold">Pricing Matrix</h6>
<button type="button" class="btn btn-success btn-sm"
onclick="addRow('editBody')">
+ Add Row
</button>
</div>

<div class="pricing-wrapper">

<table class="table table-bordered pricing-table text-center mb-0">

<thead>

<tr>
<th rowspan="2">Date Range</th>
<th colspan="4">EP</th>
<th colspan="4">CP</th>
<th colspan="4">MAP</th>
<th colspan="4">AP</th>
<th rowspan="2">Action</th>
</tr>

<tr>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
<th>Room</th><th>EB A</th><th>EB C</th><th>CNB</th>
</tr>

</thead>

<tbody id="editBody"></tbody>

</table>

</div>
</div>

<div class="col-12 text-end">
<button class="btn btn-primary">Update Pricing</button>
</div>

</form>

</div>
</div>
</div>
</div>

<script>

// load rooms
$('#property_id, #e_property_id').change(function(){
let id=$(this).val();
let target=$(this).attr('id')=='property_id'?'#room_id':'#e_room_id';

$.post("<?= base_url('room_pricing/getRoomsByProperty'); ?>",
{property_id:id},
res=>$(target).html(res));
});

function cells(plan){
return `
<td><input type="number" name="${plan}_room[]" class="form-control"></td>
<td><input type="number" name="${plan}_eba[]" class="form-control"></td>
<td><input type="number" name="${plan}_ebc[]" class="form-control"></td>
<td><input type="number" name="${plan}_cnb[]" class="form-control"></td>
`;
}

// function addRow(body){

// let row=`
// <tr>

// <td>
// <select name="price_date_id[]" class="form-control">
// <option value="">Select</option>
// <?php foreach($price_dates as $pd): ?>
// <option value="<?= $pd['id']; ?>"><?= $pd['name']; ?></option>
// <?php endforeach; ?>
// </select>
// </td>

// ${cells('ep')}
// ${cells('cp')}
// ${cells('map')}
// ${cells('ap')}

// <td><button type="button" class="btn btn-danger removeRow">X</button></td>

// </tr>
// `;

// $('#'+body).append(row);
// }

function addRow(body, selectedDate = ''){

let html = `
<tr>

<td>
<select name="price_date_id[]" class="form-control">
<option value="">Select</option>
<?php foreach($price_dates as $pd): ?>
<option value="<?= $pd['id']; ?>">
<?= $pd['name']; ?> (<?= date('d M Y', strtotime($pd['from_date'])); ?>
– <?= date('d M Y', strtotime($pd['to_date'])); ?>)
</option>
<?php endforeach; ?>
</select>
</td>

${cells('ep')}
${cells('cp')}
${cells('map')}
${cells('ap')}

<td><button type="button" class="btn btn-danger removeRow">X</button></td>

</tr>
`;

let row = $(html); // 🔥 convert to jQuery object

row.find('select').val(selectedDate);

$('#'+body).append(row);

return row; // 🔥 IMPORTANT
}


$(document).on('click','.removeRow',function(){
$(this).closest('tr').remove();
});

function openAddModal(){
$('#add-form')[0].reset();
$('#priceBody').html('');
addRow('priceBody');
$('#addModal').modal('show');
}

// load table
$("#tb").load("<?= base_url('room_pricing/viewPricing'); ?>");

// ADD submit
$("#add-form").submit(function(e){
e.preventDefault();

$.ajax({
url:"<?= base_url('room_pricing/addPricing'); ?>",
method:"POST",
data:new FormData(this),
processData:false,
contentType:false,
dataType:'json',
success:function(res){
if(res.return){
$('#addModal').modal('hide');
$("#tb").load("<?= base_url('room_pricing/viewPricing'); ?>");
toastr.success(res.msg);
}else toastr.error(res.msg);
}
});
});

// EDIT load
function editData(id){

  $.ajax({
    url:"<?= base_url('room_pricing/editPricing'); ?>",
    method:"POST",
    data:{id:id},
    dataType:"json",

    success:function(res){

      $('#edit_id').val(id);
      $('#e_property_id').val(res.property_id).trigger('change');

      setTimeout(()=>$('#e_room_id').val(res.room_id),500);

      $('#editBody').html('');

      // 🔥 fill rows from backend
      res.dates.forEach(function(date){

        let row = addRow('editBody', date.date_id);

        // plans autofill
        ['EP','CP','MAP','AP'].forEach(function(plan){

          let p = date.plans[plan] || {};

          row.find(`input[name="${plan.toLowerCase()}_room[]"]`).val(p.room_rate || '');
          row.find(`input[name="${plan.toLowerCase()}_eba[]"]`).val(p.eb_adult || '');
          row.find(`input[name="${plan.toLowerCase()}_ebc[]"]`).val(p.eb_child || '');
          row.find(`input[name="${plan.toLowerCase()}_cnb[]"]`).val(p.cnb || '');
        });

      });

      $('#editModal').modal('show');
    }
  });
}


// UPDATE submit
$("#edit-form").submit(function(e){
e.preventDefault();

$.ajax({
url:"<?= base_url('room_pricing/updatePricing'); ?>",
method:"POST",
data:new FormData(this),
processData:false,
contentType:false,
dataType:'json',
success:function(res){
if(res.return){
$('#editModal').modal('hide');
$("#tb").load("<?= base_url('room_pricing/viewPricing'); ?>");
toastr.success(res.msg);
}else toastr.error(res.msg);
}
});
});

</script>
