<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <div class="col-md-12">
            <label for="name">Destination Name</label>
            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Destination Name" required>
          </div>


          <div class="col-md-12">
            <label for="description">Description</label>
            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Enter Description"></textarea>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>

      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <div class="col-md-12">
            <label for="name">Destination Name</label>
            <input type="text" class="form-control" id="e_name" name="name" placeholder="Enter Destination Name" required>
          </div>


          <div class="col-md-12">
            <label for="description">Description</label>
            <textarea class="form-control" id="e_description" name="description" rows="3" placeholder="Enter Description"></textarea>
          </div>

          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>
<div id="cityModal" class="modal fade" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Link Cities — <span id="destinationName"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="hidden" id="destinationId">

        <div class="row mb-3">
          <div class="col-md-6">
            <h6>Suggested Cities</h6>
            <input type="text" id="filterCity" class="form-control mb-2" placeholder="Search city...">
            <ul id="cityList" class="list-group small" style="max-height:300px;overflow:auto;"></ul>
          </div>

          <div class="col-md-6">
            <h6>Linked Cities</h6>
            <ul id="linkedList" class="list-group small" style="max-height:300px;overflow:auto;"></ul>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-primary" id="btnSaveCities">Save</button>
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>


<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('destination/viewDestination'); ?>');
});

// Add Destination
$("#add-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('destination/addDestination'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#addModal').modal('hide');
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('destination/viewDestination'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Edit Destination
function editData(id) {
  $.ajax({
    url: "<?= base_url('destination/editDestination'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_id").val(res.id);
      $("#e_name").val(res.name);
      $("#e_description").val(res.description);
      $('#editModal').modal('show');
    }
  });
}

// Update Destination
$("#edit-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('destination/updateDestination'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#editModal').modal('hide');
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('destination/viewDestination'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

</script>


<script>
$(document).ready(function() {

  let selectedCities = [];
  let allCities = [];
  let destinationId = null;

  // 🔹 Open Modal
  window.openCityModal = function(id, name) {
    destinationId = id;
    $('#destinationId').val(id);
    $('#destinationName').text(name);
    $('#cityList').empty();
    $('#linkedList').empty();
    selectedCities = [];
    allCities = [];

    // Fetch already linked cities first
    $.post('<?= base_url("destination/get_linked_cities") ?>', {destination_id: id}, function(data) {
      selectedCities = data.map(d => parseInt(d.city_id));
      renderLinkedList(data);
    }, 'json');

    // Fetch suggested cities automatically
    $.post('<?= base_url("destination/fetch_cities") ?>', {destination_id: id}, function(data) {
      allCities = data;
      renderCityList(data);
      $('#cityModal').modal('show');
    }, 'json');
  }

  // 🔹 Render Suggested List
  function renderCityList(data) {
    let html = '';
    if (data.length === 0) {
      html = '<li class="list-group-item text-danger">No cities found</li>';
    } else {
      data.forEach(c => {
        const isAdded = selectedCities.includes(parseInt(c.id));
        html += `<li class="list-group-item d-flex justify-content-between align-items-center city-item">
                  <span>${c.name}</span>
                  <button class="btn btn-sm ${isAdded ? 'btn-secondary' : 'btn-outline-success'} btn-add-city" 
                    data-id="${c.id}" data-name="${c.name}" ${isAdded ? 'disabled' : ''}>
                    ${isAdded ? 'Added' : 'Add'}
                  </button>
                </li>`;
      });
    }
    $('#cityList').html(html);
  }

  // 🔹 Filter cities live
  $('#filterCity').on('keyup', function() {
    const keyword = $(this).val().toLowerCase();
    const filtered = allCities.filter(c => c.name.toLowerCase().includes(keyword));
    renderCityList(filtered);
  });

  // 🔹 Add City
  $(document).on('click', '.btn-add-city', function() {
    const id = parseInt($(this).data('id'));
    const name = $(this).data('name');
    if (!selectedCities.includes(id)) {
      selectedCities.push(id);
      $('#linkedList').append(
        `<li class="list-group-item d-flex justify-content-between align-items-center" data-id="${id}">
          ${name}
          <button class="btn btn-sm btn-danger btn-remove-city">Remove</button>
        </li>`
      );
      $(this).text('Added').addClass('btn-secondary').removeClass('btn-outline-success').prop('disabled', true);
    }
  });

  // 🔹 Remove City
  $(document).on('click', '.btn-remove-city', function() {
    const li = $(this).closest('li');
    const id = parseInt(li.data('id'));
    selectedCities = selectedCities.filter(cid => cid !== id);
    li.remove();
    // Re-enable in suggestion list
    $(`.btn-add-city[data-id="${id}"]`)
      .text('Add')
      .removeClass('btn-secondary')
      .addClass('btn-outline-success')
      .prop('disabled', false);
  });

  // 🔹 Render Linked List
  function renderLinkedList(data) {
    let html = '';
    if (data.length === 0) {
      html = '<li class="list-group-item text-muted">No linked cities</li>';
    } else {
      data.forEach(c => {
        html += `<li class="list-group-item d-flex justify-content-between align-items-center" data-id="${c.city_id}">
                  ${c.name}
                  <button class="btn btn-sm btn-danger btn-remove-city">Remove</button>
                </li>`;
      });
    }
    $('#linkedList').html(html);
  }

  // 🔹 Save Linked Cities
  $('#btnSaveCities').click(function() {
    $.ajax({
      url: '<?= base_url("destination/save_cities") ?>',
      type: 'POST',
      data: {
        destination_id: destinationId,
        city_ids: selectedCities
      },
      dataType: 'json',
      success: function(res) {
        if (res.status === 'success') {
          toastr.success('Cities linked successfully!');
          $('#cityModal').modal('hide');
        } else {
          toastr.error(res.message);
        }
      },
      error: function() {
        toastr.error('Something went wrong.');
      }
    });
  });

});
</script>


