<?php 
defined('BASEPATH') OR exit('No direct script access allowed');


function getCountryWithPhoneCode()
{
   $countries_list = array(
        array("name" => "United States", "code" => "US", "phone" => "1"),
        array("name" => "Afghanistan", "code" => "AF", "phone" => "93"),
        array("name" => "Aland Islands", "code" => "AX", "phone" => "358"),
        array("name" => "Albania", "code" => "AL", "phone" => "355"),
        array("name" => "Algeria", "code" => "DZ", "phone" => "213"),
        array("name" => "American Samoa", "code" => "AS", "phone" => "1684"),
        array("name" => "Andorra", "code" => "AD", "phone" => "376"),
        array("name" => "Angola", "code" => "AO", "phone" => "244"),
        array("name" => "Anguilla", "code" => "AI", "phone" => "1264"),
        array("name" => "Antarctica", "code" => "AQ", "phone" => "672"),
        array("name" => "Antigua and Barbuda", "code" => "AG", "phone" => "1268"),
        array("name" => "Argentina", "code" => "AR", "phone" => "54"),
        array("name" => "Armenia", "code" => "AM", "phone" => "374"),
        array("name" => "Aruba", "code" => "AW", "phone" => "297"),
        array("name" => "Australia", "code" => "AU", "phone" => "61"),
        array("name" => "Austria", "code" => "AT", "phone" => "43"),
        array("name" => "Azerbaijan", "code" => "AZ", "phone" => "994"),
        array("name" => "Bahamas", "code" => "BS", "phone" => "1242"),
        array("name" => "Bahrain", "code" => "BH", "phone" => "973"),
        array("name" => "Bangladesh", "code" => "BD", "phone" => "880"),
        array("name" => "Barbados", "code" => "BB", "phone" => "1246"),
        array("name" => "Belarus", "code" => "BY", "phone" => "375"),
        array("name" => "Belgium", "code" => "BE", "phone" => "32"),
        array("name" => "Belize", "code" => "BZ", "phone" => "501"),
        array("name" => "Benin", "code" => "BJ", "phone" => "229"),
        array("name" => "Bermuda", "code" => "BM", "phone" => "1441"),
        array("name" => "Bhutan", "code" => "BT", "phone" => "975"),
        array("name" => "Bolivia", "code" => "BO", "phone" => "591"),
        array("name" => "Bonaire, Sint Eustatius and Saba", "code" => "BQ", "phone" => "599"),
        array("name" => "Bosnia and Herzegovina", "code" => "BA", "phone" => "387"),
        array("name" => "Botswana", "code" => "BW", "phone" => "267"),
        array("name" => "Bouvet Island", "code" => "BV", "phone" => "55"),
        array("name" => "Brazil", "code" => "BR", "phone" => "55"),
        array("name" => "British Indian Ocean Territory", "code" => "IO", "phone" => "246"),
        array("name" => "Brunei Darussalam", "code" => "BN", "phone" => "673"),
        array("name" => "Bulgaria", "code" => "BG", "phone" => "359"),
        array("name" => "Burkina Faso", "code" => "BF", "phone" => "226"),
        array("name" => "Burundi", "code" => "BI", "phone" => "257"),
        array("name" => "Cambodia", "code" => "KH", "phone" => "855"),
        array("name" => "Cameroon", "code" => "CM", "phone" => "237"),
        // array("name" => "Canada", "code" => "CA", "phone" => "1"),
        array("name" => "Cape Verde", "code" => "CV", "phone" => "238"),
        array("name" => "Cayman Islands", "code" => "KY", "phone" => "1345"),
        array("name" => "Central African Republic", "code" => "CF", "phone" => "236"),
        array("name" => "Chad", "code" => "TD", "phone" => "235"),
        array("name" => "Chile", "code" => "CL", "phone" => "56"),
        array("name" => "China", "code" => "CN", "phone" => "86"),
        array("name" => "Christmas Island", "code" => "CX", "phone" => "61"),
        array("name" => "Cocos (Keeling) Islands", "code" => "CC", "phone" => "672"),
        array("name" => "Colombia", "code" => "CO", "phone" => "57"),
        array("name" => "Comoros", "code" => "KM", "phone" => "269"),
        array("name" => "Congo", "code" => "CG", "phone" => "242"),
        array("name" => "Congo, Democratic Republic of the Congo", "code" => "CD", "phone" => "242"),
        array("name" => "Cook Islands", "code" => "CK", "phone" => "682"),
        array("name" => "Costa Rica", "code" => "CR", "phone" => "506"),
        array("name" => "Cote D'Ivoire", "code" => "CI", "phone" => "225"),
        array("name" => "Croatia", "code" => "HR", "phone" => "385"),
        array("name" => "Cuba", "code" => "CU", "phone" => "53"),
        array("name" => "Curacao", "code" => "CW", "phone" => "599"),
        array("name" => "Cyprus", "code" => "CY", "phone" => "357"),
        array("name" => "Czech Republic", "code" => "CZ", "phone" => "420"),
        array("name" => "Denmark", "code" => "DK", "phone" => "45"),
        array("name" => "Djibouti", "code" => "DJ", "phone" => "253"),
        array("name" => "Dominica", "code" => "DM", "phone" => "1767"),
        array("name" => "Dominican Republic", "code" => "DO", "phone" => "1809"),
        array("name" => "Ecuador", "code" => "EC", "phone" => "593"),
        array("name" => "Egypt", "code" => "EG", "phone" => "20"),
        array("name" => "El Salvador", "code" => "SV", "phone" => "503"),
        array("name" => "Equatorial Guinea", "code" => "GQ", "phone" => "240"),
        array("name" => "Eritrea", "code" => "ER", "phone" => "291"),
        array("name" => "Estonia", "code" => "EE", "phone" => "372"),
        array("name" => "Ethiopia", "code" => "ET", "phone" => "251"),
        array("name" => "Falkland Islands (Malvinas)", "code" => "FK", "phone" => "500"),
        array("name" => "Faroe Islands", "code" => "FO", "phone" => "298"),
        array("name" => "Fiji", "code" => "FJ", "phone" => "679"),
        array("name" => "Finland", "code" => "FI", "phone" => "358"),
        array("name" => "France", "code" => "FR", "phone" => "33"),
        array("name" => "French Guiana", "code" => "GF", "phone" => "594"),
        array("name" => "French Polynesia", "code" => "PF", "phone" => "689"),
        array("name" => "French Southern Territories", "code" => "TF", "phone" => "262"),
        array("name" => "Gabon", "code" => "GA", "phone" => "241"),
        array("name" => "Gambia", "code" => "GM", "phone" => "220"),
        array("name" => "Georgia", "code" => "GE", "phone" => "995"),
        array("name" => "Germany", "code" => "DE", "phone" => "49"),
        array("name" => "Ghana", "code" => "GH", "phone" => "233"),
        array("name" => "Gibraltar", "code" => "GI", "phone" => "350"),
        array("name" => "Greece", "code" => "GR", "phone" => "30"),
        array("name" => "Greenland", "code" => "GL", "phone" => "299"),
        array("name" => "Grenada", "code" => "GD", "phone" => "1473"),
        array("name" => "Guadeloupe", "code" => "GP", "phone" => "590"),
        array("name" => "Guam", "code" => "GU", "phone" => "1671"),
        array("name" => "Guatemala", "code" => "GT", "phone" => "502"),
        array("name" => "Guernsey", "code" => "GG", "phone" => "44"),
        array("name" => "Guinea", "code" => "GN", "phone" => "224"),
        array("name" => "Guinea-Bissau", "code" => "GW", "phone" => "245"),
        array("name" => "Guyana", "code" => "GY", "phone" => "592"),
        array("name" => "Haiti", "code" => "HT", "phone" => "509"),
        array("name" => "Heard Island and Mcdonald Islands", "code" => "HM", "phone" => "0"),
        array("name" => "Holy See (Vatican City State)", "code" => "VA", "phone" => "39"),
        array("name" => "Honduras", "code" => "HN", "phone" => "504"),
        array("name" => "Hong Kong", "code" => "HK", "phone" => "852"),
        array("name" => "Hungary", "code" => "HU", "phone" => "36"),
        array("name" => "Iceland", "code" => "IS", "phone" => "354"),
        array("name" => "India", "code" => "IN", "phone" => "91"),
        array("name" => "Indonesia", "code" => "ID", "phone" => "62"),
        array("name" => "Iran, Islamic Republic of", "code" => "IR", "phone" => "98"),
        array("name" => "Iraq", "code" => "IQ", "phone" => "964"),
        array("name" => "Ireland", "code" => "IE", "phone" => "353"),
        array("name" => "Isle of Man", "code" => "IM", "phone" => "44"),
        array("name" => "Israel", "code" => "IL", "phone" => "972"),
        array("name" => "Italy", "code" => "IT", "phone" => "39"),
        array("name" => "Jamaica", "code" => "JM", "phone" => "1876"),
        array("name" => "Japan", "code" => "JP", "phone" => "81"),
        array("name" => "Jersey", "code" => "JE", "phone" => "44"),
        array("name" => "Jordan", "code" => "JO", "phone" => "962"),
        array("name" => "Kazakhstan", "code" => "KZ", "phone" => "7"),
        array("name" => "Kenya", "code" => "KE", "phone" => "254"),
        array("name" => "Kiribati", "code" => "KI", "phone" => "686"),
        array("name" => "Korea, Democratic People's Republic of", "code" => "KP", "phone" => "850"),
        array("name" => "Korea, Republic of", "code" => "KR", "phone" => "82"),
        array("name" => "Kosovo", "code" => "XK", "phone" => "381"),
        array("name" => "Kuwait", "code" => "KW", "phone" => "965"),
        array("name" => "Kyrgyzstan", "code" => "KG", "phone" => "996"),
        array("name" => "Lao People's Democratic Republic", "code" => "LA", "phone" => "856"),
        array("name" => "Latvia", "code" => "LV", "phone" => "371"),
        array("name" => "Lebanon", "code" => "LB", "phone" => "961"),
        array("name" => "Lesotho", "code" => "LS", "phone" => "266"),
        array("name" => "Liberia", "code" => "LR", "phone" => "231"),
        array("name" => "Libyan Arab Jamahiriya", "code" => "LY", "phone" => "218"),
        array("name" => "Liechtenstein", "code" => "LI", "phone" => "423"),
        array("name" => "Lithuania", "code" => "LT", "phone" => "370"),
        array("name" => "Luxembourg", "code" => "LU", "phone" => "352"),
        array("name" => "Macao", "code" => "MO", "phone" => "853"),
        array("name" => "Macedonia, the Former Yugoslav Republic of", "code" => "MK", "phone" => "389"),
        array("name" => "Madagascar", "code" => "MG", "phone" => "261"),
        array("name" => "Malawi", "code" => "MW", "phone" => "265"),
        array("name" => "Malaysia", "code" => "MY", "phone" => "60"),
        array("name" => "Maldives", "code" => "MV", "phone" => "960"),
        array("name" => "Mali", "code" => "ML", "phone" => "223"),
        array("name" => "Malta", "code" => "MT", "phone" => "356"),
        array("name" => "Marshall Islands", "code" => "MH", "phone" => "692"),
        array("name" => "Martinique", "code" => "MQ", "phone" => "596"),
        array("name" => "Mauritania", "code" => "MR", "phone" => "222"),
        array("name" => "Mauritius", "code" => "MU", "phone" => "230"),
        array("name" => "Mayotte", "code" => "YT", "phone" => "269"),
        array("name" => "Mexico", "code" => "MX", "phone" => "52"),
        array("name" => "Micronesia, Federated States of", "code" => "FM", "phone" => "691"),
        array("name" => "Moldova, Republic of", "code" => "MD", "phone" => "373"),
        array("name" => "Monaco", "code" => "MC", "phone" => "377"),
        array("name" => "Mongolia", "code" => "MN", "phone" => "976"),
        array("name" => "Montenegro", "code" => "ME", "phone" => "382"),
        array("name" => "Montserrat", "code" => "MS", "phone" => "1664"),
        array("name" => "Morocco", "code" => "MA", "phone" => "212"),
        array("name" => "Mozambique", "code" => "MZ", "phone" => "258"),
        array("name" => "Myanmar", "code" => "MM", "phone" => "95"),
        array("name" => "Namibia", "code" => "NA", "phone" => "264"),
        array("name" => "Nauru", "code" => "NR", "phone" => "674"),
        array("name" => "Nepal", "code" => "NP", "phone" => "977"),
        array("name" => "Netherlands", "code" => "NL", "phone" => "31"),
        array("name" => "Netherlands Antilles", "code" => "AN", "phone" => "599"),
        array("name" => "New Caledonia", "code" => "NC", "phone" => "687"),
        array("name" => "New Zealand", "code" => "NZ", "phone" => "64"),
        array("name" => "Nicaragua", "code" => "NI", "phone" => "505"),
        array("name" => "Niger", "code" => "NE", "phone" => "227"),
        array("name" => "Nigeria", "code" => "NG", "phone" => "234"),
        array("name" => "Niue", "code" => "NU", "phone" => "683"),
        array("name" => "Norfolk Island", "code" => "NF", "phone" => "672"),
        array("name" => "Northern Mariana Islands", "code" => "MP", "phone" => "1670"),
        array("name" => "Norway", "code" => "NO", "phone" => "47"),
        array("name" => "Oman", "code" => "OM", "phone" => "968"),
        array("name" => "Pakistan", "code" => "PK", "phone" => "92"),
        array("name" => "Palau", "code" => "PW", "phone" => "680"),
        array("name" => "Palestinian Territory, Occupied", "code" => "PS", "phone" => "970"),
        array("name" => "Panama", "code" => "PA", "phone" => "507"),
        array("name" => "Papua New Guinea", "code" => "PG", "phone" => "675"),
        array("name" => "Paraguay", "code" => "PY", "phone" => "595"),
        array("name" => "Peru", "code" => "PE", "phone" => "51"),
        array("name" => "Philippines", "code" => "PH", "phone" => "63"),
        array("name" => "Pitcairn", "code" => "PN", "phone" => "64"),
        array("name" => "Poland", "code" => "PL", "phone" => "48"),
        array("name" => "Portugal", "code" => "PT", "phone" => "351"),
        array("name" => "Puerto Rico", "code" => "PR", "phone" => "1787"),
        array("name" => "Qatar", "code" => "QA", "phone" => "974"),
        array("name" => "Reunion", "code" => "RE", "phone" => "262"),
        array("name" => "Romania", "code" => "RO", "phone" => "40"),
        array("name" => "Russian Federation", "code" => "RU", "phone" => "70"),
        array("name" => "Rwanda", "code" => "RW", "phone" => "250"),
        array("name" => "Saint Barthelemy", "code" => "BL", "phone" => "590"),
        array("name" => "Saint Helena", "code" => "SH", "phone" => "290"),
        array("name" => "Saint Kitts and Nevis", "code" => "KN", "phone" => "1869"),
        array("name" => "Saint Lucia", "code" => "LC", "phone" => "1758"),
        array("name" => "Saint Martin", "code" => "MF", "phone" => "590"),
        array("name" => "Saint Pierre and Miquelon", "code" => "PM", "phone" => "508"),
        array("name" => "Saint Vincent and the Grenadines", "code" => "VC", "phone" => "1784"),
        array("name" => "Samoa", "code" => "WS", "phone" => "684"),
        array("name" => "San Marino", "code" => "SM", "phone" => "378"),
        array("name" => "Sao Tome and Principe", "code" => "ST", "phone" => "239"),
        array("name" => "Saudi Arabia", "code" => "SA", "phone" => "966"),
        array("name" => "Senegal", "code" => "SN", "phone" => "221"),
        array("name" => "Serbia", "code" => "RS", "phone" => "381"),
        array("name" => "Serbia and Montenegro", "code" => "CS", "phone" => "381"),
        array("name" => "Seychelles", "code" => "SC", "phone" => "248"),
        array("name" => "Sierra Leone", "code" => "SL", "phone" => "232"),
        array("name" => "Singapore", "code" => "SG", "phone" => "65"),
        // array("name" => "Sint Maarten", "code" => "SX", "phone" => "1"),
        array("name" => "Slovakia", "code" => "SK", "phone" => "421"),
        array("name" => "Slovenia", "code" => "SI", "phone" => "386"),
        array("name" => "Solomon Islands", "code" => "SB", "phone" => "677"),
        array("name" => "Somalia", "code" => "SO", "phone" => "252"),
        array("name" => "South Africa", "code" => "ZA", "phone" => "27"),
        array("name" => "South Georgia and the South Sandwich Islands", "code" => "GS", "phone" => "500"),
        array("name" => "South Sudan", "code" => "SS", "phone" => "211"),
        array("name" => "Spain", "code" => "ES", "phone" => "34"),
        array("name" => "Sri Lanka", "code" => "LK", "phone" => "94"),
        array("name" => "Sudan", "code" => "SD", "phone" => "249"),
        array("name" => "Suriname", "code" => "SR", "phone" => "597"),
        array("name" => "Svalbard and Jan Mayen", "code" => "SJ", "phone" => "47"),
        array("name" => "Swaziland", "code" => "SZ", "phone" => "268"),
        array("name" => "Sweden", "code" => "SE", "phone" => "46"),
        array("name" => "Switzerland", "code" => "CH", "phone" => "41"),
        array("name" => "Syrian Arab Republic", "code" => "SY", "phone" => "963"),
        array("name" => "Taiwan, Province of China", "code" => "TW", "phone" => "886"),
        array("name" => "Tajikistan", "code" => "TJ", "phone" => "992"),
        array("name" => "Tanzania, United Republic of", "code" => "TZ", "phone" => "255"),
        array("name" => "Thailand", "code" => "TH", "phone" => "66"),
        array("name" => "Timor-Leste", "code" => "TL", "phone" => "670"),
        array("name" => "Togo", "code" => "TG", "phone" => "228"),
        array("name" => "Tokelau", "code" => "TK", "phone" => "690"),
        array("name" => "Tonga", "code" => "TO", "phone" => "676"),
        array("name" => "Trinidad and Tobago", "code" => "TT", "phone" => "1868"),
        array("name" => "Tunisia", "code" => "TN", "phone" => "216"),
        array("name" => "Turkey", "code" => "TR", "phone" => "90"),
        array("name" => "Turkmenistan", "code" => "TM", "phone" => "7370"),
        array("name" => "Turks and Caicos Islands", "code" => "TC", "phone" => "1649"),
        array("name" => "Tuvalu", "code" => "TV", "phone" => "688"),
        array("name" => "Uganda", "code" => "UG", "phone" => "256"),
        array("name" => "Ukraine", "code" => "UA", "phone" => "380"),
        array("name" => "United Arab Emirates", "code" => "AE", "phone" => "971"),
        array("name" => "United Kingdom", "code" => "GB", "phone" => "44"),
        array("name" => "Uruguay", "code" => "UY", "phone" => "598"),
        array("name" => "Uzbekistan", "code" => "UZ", "phone" => "998"),
        array("name" => "Vanuatu", "code" => "VU", "phone" => "678"),
        array("name" => "Venezuela", "code" => "VE", "phone" => "58"),
        array("name" => "Viet Nam", "code" => "VN", "phone" => "84"),
        array("name" => "Virgin Islands, British", "code" => "VG", "phone" => "1284"),
        array("name" => "Virgin Islands, U.s.", "code" => "VI", "phone" => "1340"),
        array("name" => "Wallis and Futuna", "code" => "WF", "phone" => "681"),
        array("name" => "Western Sahara", "code" => "EH", "phone" => "212"),
        array("name" => "Yemen", "code" => "YE", "phone" => "967"),
        array("name" => "Zambia", "code" => "ZM", "phone" => "260"),
        array("name" => "Zimbabwe", "code" => "ZW", "phone" => "263")
    );
    return $countries_list;
}
function checkSubscriptionExpiration($expireDate,$order_id=NULL)
{
    $CI =& get_instance();   
    $checkPaymentCount = $CI->db->get_where('payment',['order_id'=>$order_id,'is_disable'=>0])->num_rows();
    if($expireDate == NULL || $checkPaymentCount<=0 || $order_id == NULL){
        return 'expired';
    }else{
        $date1 = strtotime($expireDate);
        if($date1 >= strtotime(date('Y-m-d'))){
            return 'active';
        }else{
            return 'expired';
        }
    }
}
function isExpired($expireDate)
{
    $CI =& get_instance();   
    $date1 = strtotime($expireDate);
    if($date1 >= strtotime(date('Y-m-d'))){
        return 'active';
    }else{
        return 'expired';
    }
}
function checkSubscriptionExpirationByVendor($user_id=NULL,$vendor_id=NULL,$coupon_plan_id=NULL,$coupon_type=NULL)
{
    $CI =& get_instance(); 
    $subscriptionData = $CI->db->get_where('subscription',['user_id'=>$user_id,'vendor_id'=>$vendor_id,'DATE(expiry_date) >='=>date('Y-m-d')])->row_array();
    if($subscriptionData){
        $checkPaymentCount = $CI->db->get_where('payment',['order_id'=>$subscriptionData['id'],'is_disable'=>0])->num_rows();
        if($coupon_plan_id !== NULL && $coupon_type == 'Paid'){
            if($checkPaymentCount>0 && $coupon_plan_id == $subscriptionData['plan_id']){
                return 'active';
            }else{
                return 'expired';
            }
        }else{
            if($checkPaymentCount>0){
                return 'active';
            }else{
                return 'expired';
            }
        }
        
    }else{
        return 'expired';
    }
}
function checkSubscriptionExpirationByVendorPlan($user_id=NULL,$vendor_id=NULL,$plan_id=NULL)
{
    $CI =& get_instance(); 
    $subscriptionData = $CI->db->get_where('subscription',['user_id'=>$user_id,'vendor_id'=>$vendor_id,'DATE(expiry_date) >='=>date('Y-m-d'),'plan_id'=>$plan_id])->row_array();
    if($subscriptionData){
        $checkPaymentCount = $CI->db->get_where('payment',['order_id'=>$subscriptionData['id'],'is_disable'=>0])->num_rows();
        if($plan_id !== NULL){
            if($checkPaymentCount>0 && $plan_id == $subscriptionData['plan_id']){
                return 'active';
            }else{
                return 'expired';
            }
        }else{
            if($checkPaymentCount>0){
                return 'active';
            }else{
                return 'expired';
            }
        }
        
    }else{
        return 'expired';
    }
}
function checkAdvertisementExpiration($startDate,$expireDate)
{
    $CI =& get_instance();  
    if($startDate == NULL || $expireDate == NULL){
        return 'expired';
    }else{
        $startDate = strtotime($startDate);
        $expireDate = strtotime($expireDate);
        if($expireDate >= strtotime(date('Y-m-d')) && $startDate <= strtotime(date('Y-m-d'))){
            return 'active';
        }else{
            return 'expired';
        }
    }
}
function get_setting()
{
	$ci=& get_instance();
    $ci->load->database();
    return $ci->db->get_where('settings',[])->row_array();
}
function read_more_less($str,$length,$id)
{
    $desc = strip_tags($str);
    $desc = substr($desc,0,$length);  
    $string = '<span id="less'.$id.'">'.$desc.'</span><span id="more'.$id.'" style="display:none">'.$str.'</span>';
    if(strlen($str) > $length){
        $string .= '<span id="dots'.$id.'">...</span><a href="javascript:void(0)" onclick="readMoreLess('.$id.')" id="myBtn'.$id.'">Read more</a>';
    }
    return $string;
}
// function checkTurfSlotBooked($turf_id,$time_slot_id)
// {
//     $CI =& get_instance(); 
//     $bookingData =  $CI->model->getRowData('turf_booking',['turf_id'=>$turf_id,'time_slot_id'=>$time_slot_id]);
//     if($bookingData){
//         return false;
//     }else{
//         return true;
//     }
// }
function checkTurfSlotBooked($turf_id, $time_slot_id) 
{
    $CI =& get_instance(); 

    $CI->db->from('turf_booking')
           ->where('turf_id', $turf_id)
           ->where("FIND_IN_SET('$time_slot_id', time_slot_id) >", 0); 

    $bookingExists = $CI->db->count_all_results();

    // If booking exists, return false; otherwise, true
    return $bookingExists == 0;
}


function webLoggedUserData()
{
    $CI =& get_instance();
    $user_detail = $CI->model->getRowData('user',['id'=>get_cookie('user_id')]);
    if(get_cookie('user_id')){
        $array = array(
            'name'=>$user_detail['fullname'],
            'email'=>$user_detail['email'],
            'mobile'=>$user_detail['mobile'],
        );
    }else{
        $array = array(
            'name'=>'',
            'email'=>'',
            'mobile'=>'',
        );
    }
 
    return $array;
}

function turfCoverImage($turf_id)
{
    $CI =& get_instance();
    $imageData = $CI->model->getRowData('turf_image',['turf_id'=>$turf_id,'is_cover'=>1]);
    if($imageData){
        return base_url('assets/uploads/'.$imageData['image'].'');
    }else{
        return '';
    }
}
function fetch_city_names() {
    $CI =& get_instance();
    
    $city_ids_result = $CI->website_model->get_unique_city_ids();
    
    $city_ids = array_column($city_ids_result, 'city');
    
    $city_names = $CI->website_model->get_city_names($city_ids);
    
    return  $city_names;
}

if (!function_exists('get_average_rating')) {
    function get_average_rating()
    {
        $CI = &get_instance(); 
        $ratingData = $CI->model->getResultData('app_rating',[]);
        
        $totalRatings = count($ratingData);
        $sumRatings = array_sum(array_column($ratingData, 'rating')); 
        
        return ($totalRatings > 0) ? round($sumRatings / $totalRatings, 1) : 0;
    }
















    function get_role_permissions($role_id)
    {
        $CI = &get_instance(); 
        $CI->db->select('t2.permission_key');
        $CI->db->from('assign_permission t1');
        $CI->db->join('permission t2', 't1.permission_id = t2.id');
        $CI->db->where('t1.role_id', $role_id);
        $query = $CI->db->get();

        return array_column($query->result_array(), 'permission_key');
    }

    function has_permission($permission_key,$role_id=null) {
        $CI =& get_instance();
        
        if(isset($role_id) && $role_id!==null){
            $role_id = $role_id;
        }else{
            $role_id = $CI->session->userdata('role_id');
        }
        
    
        // Super Admin has all access
        if ($role_id == 1) return true;
    
        // Fetch permissions from DB for the given role
        $CI->db->select('t2.permission_key');
        $CI->db->from('assign_permission t1');
        $CI->db->join('permission t2', 't1.permission_id = t2.id');
        $CI->db->where('t1.role_id', $role_id);
        $query = $CI->db->get();
    
        $permissions = array_column($query->result_array(), 'permission_key');
    
        return in_array($permission_key, $permissions);
    }



    if (!function_exists('get_students_json')) {
        function get_students_json() {
            $CI =& get_instance(); 
    
            $students = $CI->user_model->getStudentResultData();
            $result = [];
    
            if (!empty($students)) {
                foreach ($students as $student) {
                    $result[] = [
                        'id'   => $student['id'],  
                        'text' => $student['fullname'],
                    ];
                }
            }
    
            return json_encode(['results' => $result]);
        }
    }

    function userData($id)
    {
        $CI =& get_instance();
        $user_detail = $CI->user_model->getUserRowData($id);
        if($id){
            $array = array(
                'name'=>$user_detail['fullname'],
                'email'=>$user_detail['email'],
                'mobile'=>$user_detail['mobile'],
                'class_standard_id'=>$user_detail['class_standard_id'],
            );
        }else{
            $array = array(
                'name'=>'',
                'email'=>'',
                'mobile'=>'',
                'class_standard_id'=>'',
            );
        }
    
        return $array;
    }

    function getColorFromScore($score)
    {
        if ($score >= 90) return 'green';
        elseif ($score >= 80) return 'amber';
        else return 'red';
    }
    function getChapterColor($student_id,$chapter_id)
    {
        $CI =& get_instance();

        $ssa = $CI->model->getRowData('ssa_score', [
            'student_id' => $student_id,
            'chapter_id' => $chapter_id
        ]);



        $score = (int) $ssa['score'];
        $color = ($score >= 90) ? 'green' : (($score >= 80) ? 'amber' : 'red');


        return $color;
    }   
    function getChapterScore($student_id,$chapter_id)
    {
        $CI =& get_instance();

        $ssa = $CI->model->getRowData('ssa_score', [
            'student_id' => $student_id,
            'chapter_id' => $chapter_id
        ]);



        $score = (int) $ssa['score'];

        return $score;
    }   
    function upload_file($field_name, $subfolder, $resize = false, $resize_width = 0, $resize_height = 0, $maintain_ratio = false)
    {
        $CI =& get_instance();

        $CI->load->library('upload');
        $CI->load->library('image_lib');

        $base_path = 'assets/uploads/';
        $upload_path = $base_path . trim($subfolder, '/');

        if (!empty($_FILES[$field_name]['name'])) {

            $file_name = rand(10000, 10000000000);
            $config['file_name']     = $file_name;
            $config['upload_path']   = './' . $upload_path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';

            // Make sure the folder exists
            if (!file_exists($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $CI->upload->initialize($config);

            if ($CI->upload->do_upload($field_name)) {
                $image_data = $CI->upload->data();
                $full_path = $image_data['full_path'];

                // Resize image if needed
                if ($resize && in_array(strtolower($image_data['file_ext']), ['.jpg', '.jpeg', '.png', '.gif'])) {
                    $config2 = [
                        'image_library'  => 'gd2',
                        'source_image'   => $full_path,
                        'new_image'      => $full_path,
                        'width'          => $resize_width,
                        'height'         => $resize_height,
                        'maintain_ratio' => $maintain_ratio
                    ];
                    $CI->image_lib->initialize($config2);
                    if (!$CI->image_lib->resize()) {
                        return ['status' => false, 'error' => $CI->image_lib->display_errors()];
                    }
                    $CI->image_lib->clear();
                }

                // Return relative path
                $relative_path = $subfolder . '/' . $image_data['file_name'];
                return ['status' => true, 'file_path' => $relative_path];
            } else {
                return ['status' => false, 'error' => $CI->upload->display_errors()];
            }
        }

        return ['status' => false, 'error' => 'No file selected.'];
    }

if (!function_exists('get_agency_slug')) {
    function get_agency_slug() {
        $CI =& get_instance();
        $host = $_SERVER['HTTP_HOST']; 

        $parts = explode('.', $host);
        return $parts[0];
    }
}

if (!function_exists('is_valid_agency_slug')) {
    function is_valid_agency_slug($slug) {
        $CI =& get_instance();
        $CI->load->database();

        $query = $CI->db->get_where('agency', ['domain_slug' => $slug], 1);
        return $query->row_array(); 
    }
}
if (!function_exists('get_logged_agency')) {
    function get_logged_agency()
    {
        $CI =& get_instance();

        // check session first
        if ($CI->session->userdata('log_user') !== 'agency') {
            return false; // not an agency user
        }

        $agency_id = $CI->session->userdata('id'); // store this on login

        if (!$agency_id) {
            return false;
        }

        // fetch from DB
        $agency = $CI->db->get_where('agency', ['id' => $agency_id])->row_array();

        return $agency ?: false;
    }
}
if (!function_exists('get_logged_user_type')) {
    function get_logged_user_type()
    {
        $CI =& get_instance();
        return $CI->session->userdata('log_user');
    }
}
function loggedUserData()
{
    $CI =& get_instance();

    $log_user = $CI->session->userdata('log_user');
    $user_id  = $CI->session->userdata('id');

    if (!$log_user || !$user_id) {
        return false;
    }

    if ($log_user === 'agency') {
        $query = $CI->db->get_where('agency', ['id' => $user_id]);
        return $query->row_array();
    } else {
        $CI->db
            ->select('t1.*, t2.role_name')
            ->from('users t1')
            ->join('roles t2', 't2.id = t1.role_id', 'left')
            ->where('t1.id', $user_id);

        $query = $CI->db->get();
        return $query->row_array();
    }
}

if (!function_exists('get_agency_url')) {
    function get_agency_url($domain_slug)
    {
        if (empty($domain_slug)) {
            return false;
        }

        $CI =& get_instance();
        $baseDomain = base_url();

        // remove protocol + trailing slash
        $baseDomain = preg_replace('#^https?://#', '', rtrim($baseDomain, '/'));

        // build full URL
        return "http://" . $domain_slug . "." . $baseDomain . "/";
    }
}

// function get_current_month_prices($type, $id, $default = 0) {
//     $CI =& get_instance();

//     if ($type === 'room') {
//         $table      = 'room_pricing';
//         $id_column  = 'room_id';
//     } elseif ($type === 'package') {
//         $table      = 'package_pricing';
//         $id_column  = 'package_id';
//     } else {
//         return [$default]; // invalid type
//     }

//     $month_start = date('Y-m-01');
//     $month_end   = date('Y-m-t');

//     $result = $CI->db
//         ->select('p.price')
//         ->from("$table p")
//         ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
//         ->where("p.$id_column", $id)
//         ->where('pd.from_date <=', $month_end)
//         ->where('pd.to_date >=', $month_start)
//         ->get()
//         ->result_array();

//     $prices = array_column($result, 'price');

//     // Return default if empty
//     return !empty($prices) ? $prices : [$default];
// }

function get_current_month_prices($type, $id, $default = 0)
{
    $CI =& get_instance();

    if ($type === 'room') {
        $table     = 'room_pricing';
        $id_column = 'room_id';
        $price_column = 'room_rate';
    } elseif ($type === 'package') {
        $table     = 'package_pricing';
        $id_column = 'package_id';
        $price_column = 'price';
    } else {
        return [
            'base_prices' => [$default],
            'markup_prices' => [$default]
        ];
    }

    $month_start = date('Y-m-01');
    $month_end   = date('Y-m-t');

    $result = $CI->db
        ->select('p.'.$price_column.'')
        ->from("$table p")
        ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
        ->where("p.$id_column", $id)
        ->where('pd.from_date <=', $month_end)
        ->where('pd.to_date >=', $month_start)
        ->get()
        ->result_array();

    $base_prices = !empty($result) ? array_column($result, 'room_rate') : [$default];

    // 🔹 Get agent data for markup
    $agent_data = $CI->user_model->getUserResultData(['t1.id' => $CI->session->userdata('id')]);
    $agent = $agent_data[0] ?? [];

    // 🔹 Apply markup to all prices
    $markup_prices = [];
    foreach ($base_prices as $price) {
        $markup_prices[] = apply_markup(floatval($price), $agent);
    }

    return [
        'base_prices'   => $base_prices,
        'markup_prices' => $markup_prices
    ];
}


//new
function apply_markup($base_price, $agent_data)
{
    if (empty($agent_data)) return $base_price;

    $markup_type  = $agent_data['markup_type'] ?? '';
    $markup_value = floatval($agent_data['markup_value'] ?? 0);

    if ($markup_type === 'percentage') {
        $markup_amount = ($base_price * $markup_value) / 100;
    } elseif ($markup_type === 'fixed') {
        $markup_amount = $markup_value;
    } else {
        $markup_amount = 0;
    }

    return round($base_price + $markup_amount, 2);
}

function get_lowest_price($type, $id, $default = 0)
{
    $CI =& get_instance();

    if ($type === 'room') {
        $table     = 'room_pricing';
        $id_column = 'room_id';
        $price_column = 'room_rate';
    } elseif ($type === 'package') {
        $table     = 'package_pricing';
        $id_column = 'package_id';
        $price_column = 'price';
    } else {
        return ['base_price' => $default, 'price_with_markup' => $default];
    }

    $result = $CI->db
        ->select_min('p.'.$price_column.'', 'lowest_price')
        ->from("$table p")
        ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
        ->where("p.$id_column", $id)
        ->get()
        ->row_array();

    $base_price = !empty($result['lowest_price']) ? floatval($result['lowest_price']) : $default;

    // 🔹 Get agent markup data
    $agent_data = $CI->user_model->getUserResultData(['t1.id' => $CI->session->userdata('id')]);

    // 🔹 Apply markup
    $price_with_markup = apply_markup($base_price, $agent_data[0] ?? []);

    // Return both for flexibility
    return [
        'base_price'        => $base_price,
        'price_with_markup' => $price_with_markup
    ];
}



// function get_lowest_price($type, $id, $default = 0) {
//     $CI =& get_instance();

//     if ($type === 'room') {
//         $table     = 'room_pricing';
//         $id_column = 'room_id';
//     } elseif ($type === 'package') {
//         $table     = 'package_pricing';
//         $id_column = 'package_id';
//     } else {
//         return $default; // invalid type
//     }

//     $result = $CI->db
//         ->select_min('p.price', 'lowest_price')
//         ->from("$table p")
//         ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
//         ->where("p.$id_column", $id)
//         ->get()
//         ->row_array();

//     return !empty($result['lowest_price']) ? floatval($result['lowest_price']) : $default;
// }


// function get_price_by_travel_date($type, $id, $travel_date, $default = 0) {
//     $CI =& get_instance();

//     if ($type === 'room') {
//         $table     = 'room_pricing';
//         $id_column = 'room_id';
//     } elseif ($type === 'package') {
//         $table     = 'package_pricing';
//         $id_column = 'package_id';
//     } else {
//         return $default;
//     }

//     $result = $CI->db
//         ->select('p.price')
//         ->from("$table p")
//         ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
//         ->where("p.$id_column", $id)
//         ->where('pd.from_date <=', $travel_date)
//         ->where('pd.to_date >=', $travel_date)
//         ->get()
//         ->row_array();

//     return !empty($result['price']) ? floatval($result['price']) : $default;
// }
// function get_price_by_travel_date($type, $id, $travel_date, $default = 0)
// {
//     $CI =& get_instance();

//     if ($type === 'room') {
//         $table     = 'room_pricing';
//         $id_column = 'room_id';
//         $price_column = 'room_rate';
//     } elseif ($type === 'package') {
//         $table     = 'package_pricing';
//         $id_column = 'package_id';
//         $price_column = 'price';
//     } else {
//         return ['base_price' => $default, 'price_with_markup' => $default];
//     }

//     $result = $CI->db
//         ->select('p.'.$price_column.'')
//         ->from("$table p")
//         ->join('price_dates pd', "p.price_date_id = pd.id", 'left')
//         ->where("p.$id_column", $id)
//         ->where('pd.from_date <=', $travel_date)
//         ->where('pd.to_date >=', $travel_date)
//         ->get()
//         ->row_array();

//     // echo "<pre>";print_r($result);die();

//     $base_price = !empty($result['room_rate']) ? floatval($result['room_rate']) : $default;

//     // 🔹 Get agent data
//     $agent_data = $CI->user_model->getUserResultData(['t1.id' => $CI->session->userdata('id')]);

//     // 🔹 Apply markup
//     $price_with_markup = apply_markup($base_price, $agent_data[0] ?? []);

//     return [
//         'base_price'        => $base_price,
//         'price_with_markup' => $price_with_markup
//     ];
// }
function get_price_by_travel_date(
    $type,
    $id,
    $travel_date,
    $default = 0,
    $plan = 'EP',
    $ea = 0,
    $ec = 0,
    $cnb = 0
){
    $CI =& get_instance();

    if ($type !== 'room') {
        return ['final_price' => $default];
    }

    $result = $CI->db
        ->select('p.room_rate, p.eb_adult, p.eb_child, p.cnb')
        ->from('room_pricing p')
        ->join('price_dates pd', 'p.price_date_id = pd.id', 'left')
        ->where('p.room_id', $id)
        ->where('p.meal_plan', strtoupper($plan))
        ->where('pd.from_date <=', $travel_date)
        ->where('pd.to_date >=', $travel_date)
        ->get()
        ->row_array();


    if(empty($result)){
        return ['final_price' => $default];
    }

    $base =
        $result['room_rate']
        + ($ea * $result['eb_adult'])
        + ($ec * $result['eb_child'])
        + ($cnb * $result['cnb']);

    // agent markup
    $agent_data = $CI->user_model
        ->getUserResultData(['t1.id' => $CI->session->userdata('id')]);

    $final = apply_markup($base, $agent_data[0] ?? []);

    return [
        'base_price'  => $base,
        'price_with_markup' => $final
    ];
}




if (!function_exists('get_package_images')) {
    function get_package_images($package_id) {
        $CI =& get_instance();
        $CI->load->database();

        // Fetch all images for the package
        $query = $CI->db->get_where('package_image', ['package_id' => $package_id]);
        $images = $query->result_array();

        $result = [
            'cover' => '',
            'gallery' => []
        ];

        foreach ($images as $img) {
            $image_url = base_url('assets/uploads/' . $img['image']);
            if (!empty($img['is_cover']) && $img['is_cover'] == 1) {
                $result['cover'] = $image_url;
            } else {
                $result['gallery'][] = $image_url;
            }
        }

        // fallback if no cover found
        if (empty($result['cover']) && !empty($result['gallery'])) {
            $result['cover'] = $result['gallery'][0];
        }

        return $result;
    }
}



}