<script>
$(document).ready(function() {
    $('#roomTable').DataTable({
        "processing": true,      // show processing indicator
        "serverSide": false,     // set to true if you want server-side processing
        "paging": true,
        "searching": true,
        "ordering": true,
        "order": [[0, "asc"]],   // default order by first column
        "lengthMenu": [10, 25, 50, 100],
        "language": {
            "search": "Filter records:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "infoEmpty": "No records available",
            "emptyTable": "No amenities found",
        }
    });
});
</script>

<!-- list table -->
<table class="table table-hover align-middle" id="inclusionTable">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Package</th>
      <th>Inclusion</th>
      <th>Created</th>
      <th class="text-center">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i = 1; foreach ($list as $val) { 
      $package      = isset($val['package_title']) ? $val['package_title'] : '';
      $inclusion    = isset($val['inclusion_text']) ? $val['inclusion_text'] : '';
      $created      = isset($val['created_at']) ? $val['created_at'] : (isset($val['created']) ? $val['created'] : '');
      $is_disable   = isset($val['is_disable']) ? $val['is_disable'] : 0;
    ?>
    <tr>
      <td><?= $i++; ?></td>

      <td>
        <i class="bi bi-box-seam me-1"></i>
        <?= htmlspecialchars($package); ?>
      </td>

      <td>
        <div 
          data-bs-toggle="tooltip" 
          data-bs-placement="top"
          title="<?= htmlspecialchars($inclusion); ?>">
          <?= htmlspecialchars($inclusion); ?>
        </div>
      </td>

      <td><?= ($created) ? date('d M, Y', strtotime($created)) : '-'; ?></td>

      <td class="text-center">
        <a href="javascript:void(0)" 
           class="btn btn-sm btn-outline-primary edit-btn"
           onclick="editData(<?= $val['id']; ?>)" 
           title="Edit">
           <i class="bi bi-pencil-square"></i>
        </a>

        <?php if ($is_disable == '0') { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                onclick="changeStatus(<?= $val['id']; ?>, '1')" title="Disable">
                <i class="bi bi-x-circle"></i>
            </a>
        <?php } else { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                onclick="changeStatus(<?= $val['id']; ?>, '0')" title="Enable">
                <i class="bi bi-check-circle"></i>
            </a>
        <?php } ?>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>




<!-- JS: DataTables init, tooltips and changeStatus -->
<script>


function changeStatus(id, newStatus) {
    if (!confirm('Are you sure you want to change status?')) return;

    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id: id,
            type: newStatus,            // send desired status string 'available' / 'unavailable'
            table: 'package_inclusions',
            column: 'is_disable',
            module: 'package inclusions'
        },
        dataType: 'json',
        success: function(res) {
            if (res.return) {
                // reload listing area
                $("#tb").load("<?= base_url('package_inclusions/viewInclusion'); ?>");
                toastr.success(res.msg);
            } else {
                toastr.error(res.msg);
            }
        },
        error: function() {
            toastr.error('Server error. Try again.');
        }
    });
}
</script>
