<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <!-- Package Dropdown -->
          <div class="col-md-12">
            <label for="package_id">Package</label>
            <select class="form-control" id="package_id" name="package_id" required>
              <option value="">Select Package</option>
              <?php foreach($packages as $p) { ?>
                <option value="<?= $p['id']; ?>"><?= htmlspecialchars($p['title']); ?></option>
              <?php } ?>
            </select>
          </div>

          <!-- Inclusion Text -->
          <div class="col-md-12">
            <label for="inclusion_text">Inclusion</label>
            <input type="text" class="form-control" id="inclusion_text" name="inclusion_text" placeholder="Enter Inclusion Text" required>
          </div>

          <!-- Submit Buttons -->
          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>



      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

            <!-- Package Dropdown -->
            <div class="col-md-12">
              <label for="package_id">Package</label>
              <select class="form-control" id="e_package_id" name="package_id" required>
                <option value="">Select Package</option>
                <?php foreach($packages as $p) { ?>
                  <option value="<?= $p['id']; ?>"><?= htmlspecialchars($p['title']); ?></option>
                <?php } ?>
              </select>
            </div>

            <!-- Inclusion Text -->
            <div class="col-md-12">
              <label for="inclusion_text">Inclusion</label>
              <input type="text" class="form-control" id="e_inclusion_text" name="inclusion_text" placeholder="Enter Inclusion Text" required>
            </div>


          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>
<script>
function add() {
  $('#addModal').modal('show');
  $('#add-form')[0].reset();
}

$(document).ready(function() {
  // show loader while table loads
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('package_inclusions/viewInclusion'); ?>');
});

// ================================
// ADD INCLUSION
// ================================
$("#add-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package_inclusions/addInclusion'); ?>",
    method: "POST",
    data: $(this).serialize(),
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#addModal').modal('hide');
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('package_inclusions/viewInclusion'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// ================================
// EDIT INCLUSION
// ================================
function editData(id) {
  $.ajax({
    url: "<?= base_url('package_inclusions/editInclusion'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_id").val(res.id);
      $("#e_package_id").val(res.package_id);
      $("#e_inclusion_text").val(res.inclusion_text);
      $('#editModal').modal('show');
    }
  });
}

// ================================
// UPDATE INCLUSION
// ================================
$("#edit-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package_inclusions/updateInclusion'); ?>",
    method: "POST",
    data: $(this).serialize(),
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#editModal').modal('hide');
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('package_inclusions/viewInclusion'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});
</script>
