<script>
$(document).ready(function() {
    $('#roomTable').DataTable({
        "processing": true,      // show processing indicator
        "serverSide": false,     // set to true if you want server-side processing
        "paging": true,
        "searching": true,
        "ordering": true,
        "order": [[0, "asc"]],   // default order by first column
        "lengthMenu": [10, 25, 50, 100],
        "language": {
            "search": "Filter records:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "infoEmpty": "No records available",
            "emptyTable": "No amenities found",
        }
    });
});
</script>

<!-- list table -->
<table class="table table-hover align-middle" id="destinationTable">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Destination Name</th>
      <th>Slug</th>
      <th>Description</th>
      <th>Created</th>
      <th class="text-center">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i = 1; foreach ($list as $val) { 
      $name    = isset($val['name']) ? $val['name'] : '';
      $slug    = isset($val['slug']) ? $val['slug'] : '';
      $desc    = isset($val['description']) ? $val['description'] : '';
      $short   = mb_strlen($desc) > 80 ? mb_substr($desc, 0, 80).'...' : $desc;
      $created = isset($val['created_at']) ? $val['created_at'] : (isset($val['created']) ? $val['created'] : '');
    ?>
    <tr>
      <td><?= $i++; ?></td>

      <td>
        <i class="bi bi-geo-alt-fill me-1"></i>
        <?= htmlspecialchars($name); ?>
      </td>

      <td>
        <span class="badge bg-secondary"><?= htmlspecialchars($slug); ?></span>
      </td>

      <td>
        <div 
          data-bs-toggle="tooltip" 
          data-bs-placement="top"
          title="<?= htmlspecialchars($desc); ?>">
          <?= htmlspecialchars($short); ?>
        </div>
      </td>

      <td><?= ($created) ? date('d M, Y', strtotime($created)) : '-'; ?></td>

      <td class="text-center">
        <a href="javascript:void(0)" 
           class="btn btn-sm btn-outline-primary edit-btn"
           onclick="editData(<?= $val['id']; ?>)" 
           title="Edit">
           <i class="bi bi-pencil-square"></i>
        </a>

        <?php if ($val['is_disable'] == '0') { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                onclick="changeStatus(<?= $val['id']; ?>, '1')" title="Disable">
                <i class="bi bi-x-circle"></i>
            </a>
        <?php } else { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                onclick="changeStatus(<?= $val['id']; ?>, '0')" title="Enable">
                <i class="bi bi-check-circle"></i>
            </a>
        <?php } ?>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>


<!-- JS: DataTables init, tooltips and changeStatus -->
<script>


function changeStatus(id, newStatus) {
    if (!confirm('Are you sure you want to change status?')) return;

    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id: id,
            type: newStatus,            // send desired status string 'available' / 'unavailable'
            table: 'destinations',
            column: 'is_disable',
            module: 'destination'
        },
        dataType: 'json',
        success: function(res) {
            if (res.return) {
                // reload listing area
                $("#tb").load("<?= base_url('destination/viewDestination'); ?>");
                toastr.success(res.msg);
            } else {
                toastr.error(res.msg);
            }
        },
        error: function() {
            toastr.error('Server error. Try again.');
        }
    });
}
</script>
