<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Agency Login</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="website_assets/img/logo.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('assets/vendor/bootstrap/css/bootstrap.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/bootstrap-icons/bootstrap-icons.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/boxicons/css/boxicons.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.snow.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.bubble.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/remixicon/remixicon.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/simple-datatables/style.css');?>" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="<?= base_url('assets/css/style.css');?>" rel="stylesheet">

</head>

<body>

<main>
  <div class="container">

    <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-5 col-md-7 d-flex flex-column align-items-center justify-content-center">

            <!-- Logo Section -->
              <div class="d-flex flex-column align-items-center py-3">
                <h3 class="text-primary fw-bold mb-0">
                    Agency Login
                </h3>
              </div>
            <!-- End Logo -->


            <!-- Error Alert -->
            <div class="alert alert-danger col-12 text-center fw-bold" style="display: none;" id="error">
              <p id="error-message" class="m-0"></p>
            </div>

            <!-- Success Alert -->
            <div class="alert alert-success col-12 text-center fw-bold" style="display: none;" id="success">
              Login Successful...
            </div>

            <!-- Login Card -->
            <div class="card shadow-lg border-0 rounded-3 mb-3">
              <div class="card-body px-4 py-4">

                <div class="text-center mb-4">
                  <h5 class="card-title fw-bold">Login to Your Account</h5>
                  <p class="small text-muted">Enter your username & password to login</p>
                </div>

                <form class="row g-3" id="login">

                  <div class="col-12">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group has-validation">
                      <input type="email" name="email" class="form-control" id="email" required>
                    </div>
                  </div>

                  <div class="col-12">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" name="login[password]" class="form-control" id="pass" required>
                    <div class="show-hide"><span class="show"></span></div>
                  </div>

                  <div class="col-12">
                    <button type="submit" class="btn btn-primary w-100 py-2 fw-bold" id="sign-in-button">
                      <span id="sign-in">Sign in</span>
                      <span id="sign-in-loader" style="display: none;">
                        <i class="fa fa-circle-o-notch fa-spin"></i> Checking...
                      </span>
                    </button>
                  </div>
                </form>

              </div>
            </div>
            <!-- End Card -->

            <div class="credits text-center small">
              Designed by <a href="https://Techicom.com/" target="_blank">Techicom</a>
            </div>

          </div>
        </div>
      </div>
    </section>

  </div>
</main>


  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="<?= base_url('assets/vendor/apexcharts/apexcharts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/bootstrap/js/bootstrap.bundle.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/chart.js/chart.umd.js');?>"></script>
  <script src="<?= base_url('assets/vendor/echarts/echarts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/quill/quill.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/simple-datatables/simple-datatables.js');?>"></script>
  <script src="<?= base_url('assets/vendor/tinymce/tinymce.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/php-email-form/validate.js');?>"></script>

  <!-- Template Main JS File -->
  <script src="<?= base_url('assets/js/main.js');?>"></script>
  <!-- login js-->
      <!-- Plugin used-->
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<script>
$('#login').submit(function(event) {
  event.preventDefault();
    var email = $('#email').val();
    var pass = $('#pass').val();
    $.ajax({
      type: "POST",
      url : "<?= base_url('Agency_auth/login');?>",
      dataType: "JSON",
      data : "email="+email+"&pass="+pass,
      cache : false,
      beforeSend: function() {
        $("#sign-in").hide();
        $("#sign-in-loader").show();
        $("#sign-in-button").attr("disabled",true);       
    }, 
      success: function(res)
      {
        if(res[0] == '0')
        {
            $("#error").hide();
            $("#success").show();
            $("#sign-in-loader").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
            setTimeout(function(){
                window.location = "dashboard";
            },2000);
        }
        else
        {
            $("#error-message").html(res[1]);
            $("#error").show();
            $("#success").hide();
            $("#sign-in").show();
            $("#sign-in-loader").hide();
            $("#sign-in-button").removeAttr("disabled"); 
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $("#error-message").html(msg);
            $("#error").show();
    },
    });
});
</script>
</body>
</html>