<?php


class Room_model extends CI_Model
{
    public function getRoomRowData($id)
	{
        $this->db
        ->select('t1.*, 
                  t2.name as property_name')
        ->from('rooms t1')
        ->join('properties t2', 't2.id = t1.property_id', 'left')
        ->where('t1.id',$id) ;


    $query = $this->db->get();




		return $query->row_array();
	}
public function getRoomResultData()
{
    $this->db
        ->select('t1.*, 
                  t2.name as property_name')
        ->from('rooms t1')
        ->join('properties t2', 't2.id = t1.property_id', 'left');

    $query = $this->db->get();
    return $query->result_array();
}
public function getRoomAmenitiesResultData()
{
    $this->db
        ->select('t1.*, t2.name as room_name,t3.name as property_name')
        ->from('room_amenities t1')
        ->join('rooms t2', 't2.id = t1.room_id', 'left')
        ->join('properties t3', 't3.id = t2.property_id', 'left');

    $query = $this->db->get();
    return $query->result_array();
}
public function getRoomPricingResultData()
{
    $this->db
        ->select('
            t1.id,
            t1.room_id,
            t1.price,
            t1.is_disable,
            t1.created_at,
            t2.name as room_name,
            t3.name as property_name,
            t4.id as price_date_id,
            t4.name as price_date_name,
            t4.from_date,
            t4.to_date
        ')
        ->from('room_pricing t1')
        ->join('rooms t2', 't2.id = t1.room_id', 'left')
        ->join('properties t3', 't3.id = t2.property_id', 'left')
        ->join('price_dates t4', 't4.id = t1.price_date_id', 'left')
        ->order_by('t2.name, t4.from_date', 'ASC');

    $query = $this->db->get();
    $result = $query->result_array();

    // Grouping result by room_id
    $grouped = [];
    foreach ($result as $row) {
        $room_id = $row['room_id'];

        if (!isset($grouped[$room_id])) {
            $grouped[$room_id] = [
                'room_id'       => $room_id,
                'room_name'     => $row['room_name'],
                'property_name' => $row['property_name'],
                'is_disable'    => $row['is_disable'],
                'created_at'    => $row['created_at'],
                'prices'        => [] // will hold multiple date-price records
            ];
        }

        $grouped[$room_id]['prices'][] = [
            'price_date_name' => $row['price_date_name'],
            'from_date'       => $row['from_date'],
            'to_date'         => $row['to_date'],
            'price'           => $row['price'],
        ];
    }

    return array_values($grouped); // reset numeric keys for foreach in view
}

}

?>