<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }

    // Get all packages
    public function get_all_packages()
    {
        $this->db->select('p.*, d.name as destination_name');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.is_disable', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    // Check duplicate field (package_code)
    public function check_duplicate($field, $value, $exclude_id = null)
    {
        $this->db->where($field, $value);
        if ($exclude_id) {
            $this->db->where('id !=', $exclude_id);
        }
        $this->db->where('is_disable', 0);
        return $this->db->count_all_results('packages');
    }

    // Insert new package
    public function insert_package($data)
    {
        $array = [
            'destination_id' => $data['destination_id'],
            'package_name'   => $data['package_name'],
            'package_code'   => $data['package_code'],
            'nights'         => $data['nights'],
            'days'           => $data['days'],
            'price'          => $data['price'],
            'created'        => date('Y-m-d H:i:s'),
            'updated'        => date('Y-m-d H:i:s'),
        ];

        $this->db->insert('packages', $array);
        return $this->db->insert_id();
    }

    // Get package by ID
    public function get_package($id)
    {
        $this->db->select('p.*, d.name as destination_name');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->where('p.is_disable', 0);
        $query = $this->db->get();
        return $query->row_array();
    }

    // Update package
    public function update_package($id, $data)
    {
        $array = [
            'destination_id' => $data['destination_id'],
            'package_name'   => $data['package_name'],
            'package_code'   => $data['package_code'],
            'nights'         => $data['nights'],
            'days'           => $data['days'],
            'price'          => $data['price'],
            'updated'        => date('Y-m-d H:i:s'),
        ];

        $this->db->where('id', $id);
        return $this->db->update('packages', $array);
    }

    // Soft delete package
    public function delete_package($id)
    {
        $this->db->where('id', $id);
        return $this->db->update('packages', [
            'is_disable' => 1,
            'updated'    => date('Y-m-d H:i:s')
        ]);
    }

    // Insert package-themes mapping
    public function insert_package_themes($package_id, $themes)
    {
        $data = [];
        foreach ($themes as $theme_id) {
            $data[] = [
                'package_id' => $package_id,
                'theme_id'   => $theme_id,
                'created'    => date('Y-m-d H:i:s'),
                'updated'    => date('Y-m-d H:i:s')
            ];
        }
        if (!empty($data)) {
            $this->db->insert_batch('package_themes_mapping', $data);
        }
    }

    // Update package-themes mapping
    public function update_package_themes($package_id, $themes)
    {
        // Delete existing mappings
        $this->db->where('package_id', $package_id);
        $this->db->delete('package_themes_mapping');

        // Insert new mappings
        $this->insert_package_themes($package_id, $themes);
    }

    // Insert package-inclusions mapping
    public function insert_package_inclusions($package_id, $inclusions)
    {
        $data = [];
        foreach ($inclusions as $inc_id) {
            $data[] = [
                'package_id' => $package_id,
                'inclusion_id' => $inc_id,
                'created'    => date('Y-m-d H:i:s'),
                'updated'    => date('Y-m-d H:i:s')
            ];
        }
        if (!empty($data)) {
            $this->db->insert_batch('package_inclusions_mapping', $data);
        }
    }

    // Update package-inclusions mapping
    public function update_package_inclusions($package_id, $inclusions)
    {
        // Delete existing mappings
        $this->db->where('package_id', $package_id);
        $this->db->delete('package_inclusions_mapping');

        // Insert new mappings
        $this->insert_package_inclusions($package_id, $inclusions);
    }

    public function getPackagePricingResultData()
    {
        $this->db
            ->select('
                pp.id,
                pp.package_id,
                pp.price,
                pp.is_disable,
                pp.created_at,
                p.title as package_name,
                pd.id as price_date_id,
                pd.name as price_date_name,
                pd.from_date,
                pd.to_date
            ')
            ->from('package_pricing pp')
            ->join('packages p', 'p.id = pp.package_id', 'left')
            ->join('price_dates pd', 'pd.id = pp.price_date_id', 'left')
            ->order_by('p.title, pd.from_date', 'ASC');

        $query = $this->db->get();
        $result = $query->result_array();

        // Group results by package_id
        $grouped = [];
        foreach ($result as $row) {
            $package_id = $row['package_id'];

            if (!isset($grouped[$package_id])) {
                $grouped[$package_id] = [
                    'package_id'     => $package_id,
                    'package_name'   => $row['package_name'],
                    'is_disable'     => $row['is_disable'],
                    'created_at'     => $row['created_at'],
                    'prices'         => [] // multiple date-price entries
                ];
            }

            $grouped[$package_id]['prices'][] = [
                'price_date_name' => $row['price_date_name'],
                'from_date'       => $row['from_date'],
                'to_date'         => $row['to_date'],
                'price'           => $row['price']
            ];
        }

        return array_values($grouped); // reset keys for foreach in view
    }

}
